/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.dom.DOMExceptionImpl;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.dom.DocumentTypeImpl;
import com.novell.xml.util.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class DOMImplementationImpl
implements DOMImplementation {
    private static DOMImplementationImpl domImplementation = null;

    public boolean hasFeature(String feature, String version) {
        return DOMImplementationImpl.checkFeature(feature, version);
    }

    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) throws DOMException {
        if (!XMLUtil.isXMLName(qualifiedName)) {
            throw new DOMExceptionImpl(5, null);
        }
        if (!XMLUtil.isQName(qualifiedName)) {
            throw new DOMExceptionImpl(14, null);
        }
        return new DocumentTypeImpl(null, qualifiedName, publicId, systemId, null);
    }

    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        DocumentImpl document = DocumentImpl.newDocument();
        if (doctype != null) {
            if (doctype instanceof DocumentTypeImpl) {
                document.setDocumentType((DocumentTypeImpl)doctype);
            } else {
                throw new DOMExceptionImpl(4, null);
            }
        }
        if (qualifiedName != null) {
            document.appendChild(document.createElementNS(namespaceURI, qualifiedName));
        }
        return document;
    }

    public static DOMImplementation getDOMImplementation() {
        if (domImplementation == null) {
            domImplementation = new DOMImplementationImpl();
        }
        return domImplementation;
    }

    protected static boolean checkFeature(String feature, String version) {
        if (!feature.equalsIgnoreCase("XML") && !feature.equalsIgnoreCase("Core")) {
            return false;
        }
        return version == null || version.length() == 0 || version.equals("1.0") || version.equals("2.0");
    }

    private DOMImplementationImpl() {
    }
}

