/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.dom.StringNamespaceContext;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.NamespaceContext;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.Parser;
import com.novell.xml.xpath.SingleNodeList;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.XPathResetCache;
import com.novell.xml.xpath.XPathResetRegistrar;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

public class DOMQuery
implements XPathResetRegistrar {
    private Expression expression;
    private ExpressionContext context;
    private SingleNodeList nodeList = new SingleNodeList();
    private List resetList = new ArrayList();

    public static NodeSet query(Node node, String expression) throws XPathEvaluationException {
        ExpressionContext nsContext = new ExpressionContext();
        nsContext.setNamespaceContext(node);
        DOMQuery query = new DOMQuery(expression, nsContext);
        return query.evaluate(node);
    }

    public static NodeSet query(Node node, String expression, List namespaces) throws XPathEvaluationException {
        StringNamespaceContext nsContext = new StringNamespaceContext(namespaces);
        DOMQuery query = new DOMQuery(expression, nsContext);
        return query.evaluate(node);
    }

    public static NodeSet query(Node node, String expression, String[] namespaces) throws XPathEvaluationException {
        StringNamespaceContext nsContext = new StringNamespaceContext(namespaces);
        DOMQuery query = new DOMQuery(expression, nsContext);
        return query.evaluate(node);
    }

    public static Node queryFirst(Node node, String expression) throws XPathEvaluationException {
        return DOMQuery.query(node, expression).first();
    }

    public static Node queryFirst(Node node, String expression, List namespaces) throws XPathEvaluationException {
        return DOMQuery.query(node, expression, namespaces).first();
    }

    public static Node queryFirst(Node node, String expression, String[] namespaces) throws XPathEvaluationException {
        return DOMQuery.query(node, expression, namespaces).first();
    }

    public DOMQuery(String expression) throws IllegalArgumentException {
        this(expression, null);
    }

    public DOMQuery(String expression, NamespaceContext nsContext) throws IllegalArgumentException {
        try {
            this.context = DOMQuery.createContext();
            this.context.setContextNodeList(this.nodeList);
            Parser xpathParser = new Parser(nsContext == null ? this.context : nsContext);
            this.expression = xpathParser.parse(expression);
            if (!NodeSet.getArgType().isAssignableFrom(this.expression.getResultType())) {
                throw new IllegalArgumentException("DOMQuery: expected a node-set expression");
            }
            this.expression.registerForReset(this);
        }
        catch (XPathParserException e) {
            throw new IllegalArgumentException("DOMQuery parser error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeSet evaluate(Node node) throws XPathEvaluationException {
        this.nodeList.setNode(node);
        try {
            NodeSet nodeSet = this.expression.evaluate(node, this.context).getNodeSetValue();
            return nodeSet;
        }
        finally {
            this.nodeList.setNode(null);
            this.reset();
        }
    }

    private static ExpressionContext createContext() {
        return new ExpressionContext();
    }

    public void registerResetCache(XPathResetCache reset) {
        this.resetList.add(reset);
    }

    private void reset() {
        Iterator it = this.resetList.iterator();
        while (it.hasNext()) {
            ((XPathResetCache)it.next()).resetCache();
        }
    }

    public static class StringNSContext
    extends StringNamespaceContext {
        StringNSContext(List namespaceList) throws IllegalArgumentException {
            super(namespaceList);
        }

        StringNSContext(String[] namespaceArray) throws IllegalArgumentException {
            super(namespaceArray);
        }
    }
}

