/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.util.URIResolver;
import com.novell.xml.dom.DOMImplementationImpl;
import com.novell.xml.dom.DOMWriter;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.dom.ElementImpl;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.StylesheetAssociation;
import com.novell.xml.util.XMLUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Stack;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public final class DOMUtil {
    private static final NodeComparator nodeComparator = new NodeComparator();
    private static final DeepNodeComparator deepNodeComparator = new DeepNodeComparator();

    public static void printDocument(Writer writer, Document document) throws IOException {
        DOMWriter domWriter = new DOMWriter(document, writer);
        domWriter.write();
        writer.flush();
    }

    public static void printDocumentWithFormat(Writer writer, Document document) throws IOException {
        DOMWriter domWriter = new DOMWriter(document, writer);
        domWriter.setIndent(true);
        domWriter.write();
        writer.flush();
    }

    public static void printFragment(Writer writer, Node fragment) throws IOException {
        DOMWriter domWriter = new DOMWriter(fragment, writer);
        domWriter.write();
        writer.flush();
    }

    public static void stripWhitespace(Node root) {
        if (root == null) {
            return;
        }
        Node currentNode = root;
        boolean strip = true;
        for (Node ancestor = currentNode; ancestor != null; ancestor = ancestor.getParentNode()) {
            String xmlSpace;
            if (ancestor.getNodeType() != 1 || (xmlSpace = ((Element)ancestor).getAttribute("xml:space")).length() <= 0) continue;
            strip = !xmlSpace.equals("preserve");
            break;
        }
        Stack<Boolean> state = new Stack<Boolean>();
        while (currentNode != null) {
            boolean stripNode = false;
            short nodeType = currentNode.getNodeType();
            if (nodeType == 1) {
                state.push(strip ? Boolean.TRUE : Boolean.FALSE);
                String xmlSpace = ((Element)currentNode).getAttribute("xml:space");
                if (xmlSpace.length() > 0) {
                    strip = !xmlSpace.equals("preserve");
                }
            } else if (nodeType == 3) {
                Node sibling = currentNode.getNextSibling();
                while (sibling != null) {
                    if (sibling.getNodeType() == 3) {
                        ((CharacterData)currentNode).appendData(sibling.getNodeValue());
                        currentNode.getParentNode().removeChild(sibling);
                        sibling = currentNode.getNextSibling();
                        continue;
                    }
                    sibling = null;
                }
                stripNode = strip && XMLUtil.isXMLWhitespace(currentNode.getNodeValue());
            }
            Node saveNode = currentNode;
            if (currentNode.hasChildNodes()) {
                currentNode = currentNode.getFirstChild();
            } else {
                while (currentNode != null && currentNode != root) {
                    if (currentNode.getNodeType() == 1) {
                        strip = (Boolean)state.pop();
                    }
                    if (currentNode.getNextSibling() != null) {
                        currentNode = currentNode.getNextSibling();
                        break;
                    }
                    currentNode = currentNode.getParentNode();
                }
                Node node = currentNode = currentNode == root ? null : currentNode;
            }
            if (!stripNode) continue;
            saveNode.getParentNode().removeChild(saveNode);
        }
    }

    public static String describeNode(Node node) {
        switch (node.getNodeType()) {
            case 9: {
                return "/";
            }
            case 1: {
                String result = "<" + node.getNodeName() + ">";
                NamedNodeMap attrs = node.getAttributes();
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        result = result + " " + DOMUtil.describeNode(attrs.item(i));
                    }
                }
                return result;
            }
            case 2: {
                return "@" + node.getNodeName() + " = \"" + node.getNodeValue() + "\"";
            }
            case 8: {
                return "<!--" + XMLUtil.escape(node.getNodeValue(), 50) + "-->";
            }
            case 7: {
                return "<?" + node.getNodeName() + " " + XMLUtil.escape(node.getNodeValue(), 50) + "?>";
            }
            case 3: 
            case 4: {
                return XMLUtil.quote(node.getNodeValue(), 50);
            }
        }
        return "?? node(" + node.getNodeType() + ")";
    }

    public static ExpandedQName getExpandedName(Node node) {
        if (node instanceof NodeImpl) {
            return ((NodeImpl)node).getExpandedName();
        }
        short nodeType = node.getNodeType();
        String name = node.getNodeName();
        if (nodeType == 1 || nodeType == 2 && !XMLUtil.isNamespaceDecl(name)) {
            return new ExpandedQName(name, node);
        }
        return new ExpandedQName("", name, "");
    }

    public static String getLocalName(Node node) {
        return XMLUtil.getLocalName(node.getNodeName());
    }

    public static NamespaceName getNamespaceName(Node node) {
        if (node instanceof NodeImpl) {
            return ((NodeImpl)node).getExpandedName().getNamespaceName();
        }
        String prefix = XMLUtil.getPrefix(node.getNodeName());
        if (prefix.length() == 0 && node.getNodeType() == 2) {
            return NamespaceName.NULL_NAMESPACE;
        }
        return new NamespaceName(DOMUtil.getURIforNSPrefix(prefix, node));
    }

    private static NamespaceName getNamespaceNameFromDecl(Node node) {
        String prefix = XMLUtil.getPrefix(node.getNodeName());
        if (prefix.length() == 0 && node.getNodeType() == 2) {
            return NamespaceName.NULL_NAMESPACE;
        }
        return new NamespaceName(DOMUtil.getURIforNSPrefix(prefix, node));
    }

    public static String getURIforNSPrefix(String prefix, Node node) {
        if (prefix == null) {
            prefix = "";
        }
        if (prefix.equals("xml")) {
            return NamespaceName.XML_NAMESPACE.getString();
        }
        boolean isNovellDOM = node instanceof NodeImpl;
        String attributeName = prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix;
        Node element = node;
        while (element != null) {
            if (element.getNodeType() == 1) {
                if (isNovellDOM) {
                    Node namespaceNode = ((ElementImpl)element).getNamespaces().getNamedItem(prefix);
                    return namespaceNode != null ? namespaceNode.getNodeValue() : null;
                }
                Attr attrNode = ((Element)element).getAttributeNode(attributeName);
                if (attrNode != null) {
                    return attrNode.getValue();
                }
            }
            if (element.getNodeType() == 2) {
                element = ((Attr)element).getOwnerElement();
                continue;
            }
            element = element.getParentNode();
        }
        return attributeName == "xmlns" ? "" : null;
    }

    public static String getPrefixforNSURI(String namespaceURI, Node node) {
        if (namespaceURI.equals(NamespaceName.XML_NAMESPACE.getString())) {
            return "xml";
        }
        boolean isNovellDOM = node instanceof NodeImpl;
        for (Node element = node; element != null; element = element.getParentNode()) {
            Node attr;
            int i;
            if (element.getNodeType() == 1 && isNovellDOM) {
                Node namespaceNode;
                NamedNodeMap namespaceNodes = ((ElementImpl)element).getNamespaces();
                i = 0;
                while ((namespaceNode = namespaceNodes.item(i)) != null) {
                    String prefix = namespaceNode.getNodeName();
                    if (namespaceNode.getNodeValue().equals(namespaceURI) && namespaceNode == namespaceNodes.getNamedItem(prefix)) {
                        return prefix;
                    }
                    ++i;
                }
                return null;
            }
            NamedNodeMap attrs = ((Element)element).getAttributes();
            i = 0;
            while ((attr = attrs.item(i)) != null) {
                String prefix;
                String checkURI;
                String attrName = attr.getNodeName();
                if (XMLUtil.isNamespaceDecl(attrName) && attr.getNodeValue().equals(namespaceURI) && (checkURI = DOMUtil.getURIforNSPrefix(prefix = XMLUtil.getPrefix(attrName), node)) != null && checkURI.equals(namespaceURI)) {
                    return prefix;
                }
                ++i;
            }
        }
        return null;
    }

    public static Element getElementByID(Document document, String idValue) {
        if (document == null || !(document instanceof DocumentImpl)) {
            return null;
        }
        return ((DocumentImpl)document).findElementById(idValue);
    }

    public static StylesheetAssociation[] getStylesheetAssociations(Document document, String baseURI) {
        ArrayList<StylesheetAssociation> list = new ArrayList<StylesheetAssociation>();
        for (Node node = document.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
            if (node.getNodeType() != 7 || !((ProcessingInstruction)node).getTarget().equals("xml-stylesheet")) continue;
            ProcessingInstruction spi = (ProcessingInstruction)node;
            String data = spi.getData();
            String href = XMLUtil.getPseudoAttribute(data, "href");
            String type = XMLUtil.getPseudoAttribute(data, "type");
            String title = XMLUtil.getPseudoAttribute(data, "title");
            String media = XMLUtil.getPseudoAttribute(data, "media");
            String charset = XMLUtil.getPseudoAttribute(data, "charset");
            boolean alternate = XMLUtil.getPseudoAttribute(data, "alternate").equals("yes");
            String base = null;
            if (baseURI != null) {
                base = baseURI;
            } else if (document instanceof NodeImpl) {
                base = ((NodeImpl)((Object)document)).getBaseURI();
            }
            href = URIResolver.resolveURI(href, base);
            list.add(new StylesheetAssociation(href, type, title, media, charset, alternate));
        }
        StylesheetAssociation[] associations = new StylesheetAssociation[list.size()];
        list.toArray(associations);
        return associations;
    }

    public static Document cloneDocument(Document srcDoc) throws DOMException {
        if (srcDoc != null) {
            DOMImplementation destImpl = DOMImplementationImpl.getDOMImplementation();
            DocumentType srcDocType = srcDoc.getDoctype();
            DocumentType destDocType = null;
            DocumentImpl destDoc = null;
            if (srcDocType != null) {
                Node srcEntity;
                Node srcNotation;
                destDocType = destImpl.createDocumentType(srcDocType.getName(), srcDocType.getPublicId(), srcDocType.getSystemId());
                destDoc = (DocumentImpl)destImpl.createDocument(null, null, destDocType);
                destDoc.setSmartNS(true);
                NamedNodeMap srcNotations = srcDocType.getNotations();
                NamedNodeMap destNotations = destDocType.getNotations();
                int i = 0;
                while ((srcNotation = srcNotations.item(i)) != null) {
                    destNotations.setNamedItem(destDoc.importNode(srcNotation, true));
                    ++i;
                }
                NamedNodeMap srcEntities = srcDocType.getEntities();
                NamedNodeMap destEntities = destDocType.getEntities();
                int i2 = 0;
                while ((srcEntity = srcEntities.item(i2)) != null) {
                    destEntities.setNamedItem(destDoc.importNode(srcEntity, true));
                    ++i2;
                }
            } else {
                destDoc = (DocumentImpl)destImpl.createDocument(null, null, null);
                destDoc.setSmartNS(true);
            }
            for (Node srcChild = srcDoc.getFirstChild(); srcChild != null; srcChild = srcChild.getNextSibling()) {
                if (srcChild.getNodeType() == 10) continue;
                destDoc.appendChild(destDoc.importNode(srcChild, true));
            }
            return destDoc;
        }
        return null;
    }

    public static boolean checkNamespacesAgree(Node node) {
        try {
            short nodeType = node.getNodeType();
            if (nodeType == 2 || nodeType == 1) {
                NamespaceName namespaceFromDOM;
                NamespaceName namespaceFromDecl;
                String localPart = node.getLocalName();
                if (localPart == null) {
                    return false;
                }
                if (!(nodeType == 2 && XMLUtil.isNamespaceDecl(node.getNodeName()) || (namespaceFromDecl = DOMUtil.getNamespaceName(node)).equals(namespaceFromDOM = new NamespaceName(node.getNamespaceURI())) || node.getNamespaceURI() == null && namespaceFromDecl.equals(ExpandedQName.UNKNOWN_NAMESPACE))) {
                    return false;
                }
            }
            switch (nodeType) {
                case 1: {
                    Node attr;
                    NamedNodeMap attrs = node.getAttributes();
                    int i = 0;
                    while ((attr = attrs.item(i++)) != null) {
                        if (DOMUtil.checkNamespacesAgree(attr)) continue;
                        return false;
                    }
                }
                case 5: 
                case 6: 
                case 9: 
                case 11: {
                    for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (DOMUtil.checkNamespacesAgree(child)) continue;
                        return false;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean addNamespaceDecls(Node node) {
        boolean updated = false;
        short nodeType = node.getNodeType();
        if (nodeType == 2 || nodeType == 1) {
            String defaultNamespace;
            String namespaceURI = node.getNamespaceURI();
            if (!(namespaceURI == null || nodeType == 2 && XMLUtil.isNamespaceDecl(node.getNodeName()))) {
                NamespaceName namespaceFromDOM;
                NamespaceName namespaceFromDecl = DOMUtil.getNamespaceNameFromDecl(node);
                if (!namespaceFromDecl.equals(namespaceFromDOM = new NamespaceName(node.getNamespaceURI()))) {
                    Element ownerElement = nodeType == 2 ? ((Attr)node).getOwnerElement() : (Element)node;
                    String nsPrefix = DOMUtil.getPrefixforNSURI(namespaceURI, ownerElement);
                    if (nsPrefix != null) {
                        node.setPrefix(nsPrefix.length() > 0 ? nsPrefix : null);
                    } else {
                        String prefix = node.getPrefix();
                        if (nodeType == 2) {
                            String origPrefix = prefix;
                            int counter = 1;
                            ownerElement = ((Attr)node).getOwnerElement();
                            while (ownerElement.getAttribute("xmlns:" + prefix).length() > 0) {
                                prefix = origPrefix + '-' + String.valueOf(counter++);
                            }
                        } else {
                            ownerElement = (Element)node;
                        }
                        String declName = "xmlns";
                        if (prefix != null) {
                            declName = declName + ":" + prefix;
                        }
                        ownerElement.setAttributeNS(NamespaceName.XMLNS_NAMESPACE.getString(), declName, namespaceURI);
                    }
                    updated = true;
                }
            } else if (nodeType == 1 && (defaultNamespace = DOMUtil.getURIforNSPrefix(null, node)) != null && defaultNamespace.length() > 0) {
                ((Element)node).setAttributeNS(NamespaceName.XMLNS_NAMESPACE.getString(), "xmlns", "");
            }
        }
        switch (nodeType) {
            case 1: {
                Node attr;
                NamedNodeMap attrs = node.getAttributes();
                int i = 0;
                boolean isUpdated = false;
                while ((attr = attrs.item(i++)) != null) {
                    isUpdated = DOMUtil.addNamespaceDecls(attr);
                    if (isUpdated) {
                        ++i;
                    }
                    updated |= isUpdated;
                }
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    updated = DOMUtil.addNamespaceDecls(child) | updated;
                }
                break;
            }
        }
        return updated;
    }

    public static boolean stringsEqual(String str1, String str2) {
        return str1 == str2 || str1 != null && str2 != null && str1.equals(str2);
    }

    public static int stringCompare(String str1, String str2) {
        if (str1 == str2) {
            return 0;
        }
        if (str2 == null) {
            return 1;
        }
        if (str1 == null) {
            return -1;
        }
        return str1.compareTo(str2);
    }

    private DOMUtil() {
    }

    public static int compareNodes(Node node1, Node node2) {
        if (node1 == node2) {
            return 0;
        }
        short nodeType = node1.getNodeType();
        int retVal = nodeType - node2.getNodeType();
        if (retVal != 0) {
            return retVal;
        }
        switch (nodeType) {
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                retVal = DOMUtil.stringCompare(node1.getNodeName(), node2.getNodeName());
                if (retVal != 0) {
                    return retVal;
                }
            }
            case 1: 
            case 2: {
                retVal = DOMUtil.stringCompare(node1.getNamespaceURI(), node2.getNamespaceURI());
                if (retVal != 0) {
                    return retVal;
                }
                retVal = DOMUtil.stringCompare(node1.getLocalName(), node2.getLocalName());
                if (retVal == 0) break;
                return retVal;
            }
        }
        switch (nodeType) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                retVal = DOMUtil.stringCompare(node1.getNodeValue(), node2.getNodeValue());
                if (retVal == 0) break;
                return retVal;
            }
        }
        return 0;
    }

    public static int deepCompareNodes(Node node1, Node node2) {
        int retVal = DOMUtil.compareNodes(node1, node2);
        if (retVal != 0) {
            return retVal;
        }
        if (node1.getNodeType() == 1) {
            Element element1 = (Element)node1;
            Element element2 = (Element)node2;
            NamedNodeMap attrs1 = element1.getAttributes();
            NamedNodeMap attrs2 = element2.getAttributes();
            int attrCount = attrs1.getLength();
            retVal = attrCount - attrs2.getLength();
            if (retVal != 0) {
                return retVal;
            }
            for (int i = 0; i < attrCount; ++i) {
                Node attr1 = attrs1.item(i);
                retVal = DOMUtil.compareNodes(attr1, attrs2.getNamedItemNS(attr1.getNamespaceURI(), attr1.getLocalName()));
                if (retVal == 0) continue;
                return retVal;
            }
        }
        NodeList children1 = node1.getChildNodes();
        NodeList children2 = node2.getChildNodes();
        int childCount = children1.getLength();
        for (int i = 0; i < childCount; ++i) {
            retVal = DOMUtil.compareNodes(children1.item(i), children2.item(i));
            if (retVal == 0) continue;
            return retVal;
        }
        return 0;
    }

    public static Comparator getNodeComparator() {
        return nodeComparator;
    }

    public static Comparator getDeepNodeComparator() {
        return deepNodeComparator;
    }

    private static class DeepNodeComparator
    implements Comparator {
        private DeepNodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            return DOMUtil.deepCompareNodes((Node)o1, (Node)o2);
        }
    }

    private static class NodeComparator
    implements Comparator {
        private NodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            return DOMUtil.compareNodes((Node)o1, (Node)o2);
        }
    }
}

