/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.io.EncodingStreamWriter;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.util.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMWriter
implements XmlWriter {
    protected Node root;
    protected Node firstDocChild = null;
    protected Writer writer;
    protected String encoding = null;
    protected boolean indent = false;
    protected boolean writeDeclaration = false;
    protected boolean standalone = false;
    protected String doctypePublic = null;
    protected String doctypeSystem = null;
    protected int indentLevel = 0;
    protected boolean disableTextEscaping = false;
    protected Collection cdataSectionElements = null;
    protected boolean cdataOutput;
    protected Stack stack = new Stack();
    protected static final int XML_SPACE_DEFAULT = 0;
    protected static final int XML_SPACE_PRESERVE = 1;
    protected static final Integer xmlSpaceDefault = new Integer(0);
    protected static final Integer xmlSpacePreserve = new Integer(1);
    protected int xmlSpace = 0;
    protected String indentString = "\t";
    protected int baseIndentLevel = 0;

    public DOMWriter(Node node, Writer writer) {
        this.root = node;
        this.writer = writer;
    }

    public DOMWriter(Node node, OutputStream outputStream, String encoding) throws UnsupportedEncodingException {
        this.root = node;
        this.encoding = encoding;
        try {
            this.writer = new EncodingStreamWriter(outputStream, encoding);
        }
        catch (UnsupportedEncodingException e) {
            this.writer = new OutputStreamWriter(outputStream, encoding);
        }
    }

    public void write() throws IOException {
        this.indentLevel = this.baseIndentLevel;
        if (this.writeDeclaration) {
            this.writeDeclaration();
        }
        this.writeTree(this.root);
        this.flush();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public boolean getWriteDeclaration() {
        return this.writeDeclaration;
    }

    public void setWriteDeclaration(boolean writeDeclaration) {
        this.writeDeclaration = writeDeclaration;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean getIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString;
    }

    public void setBaseIndentLevel(int level) {
        this.baseIndentLevel = level;
    }

    public boolean getStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public String getDoctypePublic() {
        return this.doctypePublic;
    }

    public void setDoctypePublic(String doctypePublic) {
        this.doctypePublic = doctypePublic;
    }

    public String getDoctypeSystem() {
        return this.doctypeSystem;
    }

    public void setDoctypeSystem(String doctypeSystem) {
        this.doctypeSystem = doctypeSystem;
    }

    public boolean getDisableTextEscaping() {
        return this.disableTextEscaping;
    }

    public void setDisableTextEscaping(boolean disableTextEscaping) {
        this.disableTextEscaping = disableTextEscaping;
    }

    public Collection getCdataSectionElements() {
        return this.cdataSectionElements;
    }

    public void setCdataSectionElements(Collection cdataSectionElements) {
        this.cdataSectionElements = cdataSectionElements;
    }

    protected void writeDeclaration() throws IOException {
        this.writer.write("<?xml version=\"1.0\"");
        if (this.encoding != null && this.encoding.length() > 0) {
            this.writer.write(" encoding=\"" + this.encoding + "\"");
        }
        if (this.standalone) {
            this.writer.write(" standalone=\"yes\"");
        }
        this.writer.write("?>");
    }

    protected void writeDTD(Document node) throws IOException {
        Node firstElement;
        DocumentType docType = node.getDoctype();
        for (firstElement = node.getFirstChild(); firstElement != null && firstElement.getNodeType() != 1; firstElement = firstElement.getNextSibling()) {
        }
        if (docType == null && firstElement == null) {
            return;
        }
        this.writer.write("<!DOCTYPE ");
        if (docType != null) {
            this.writer.write(docType.getName());
        } else {
            this.writer.write(DOMUtil.getLocalName(firstElement));
        }
        if (this.doctypePublic != null && this.doctypePublic.length() > 0) {
            this.writer.write(" PUBLIC ");
            int quote = this.doctypePublic.indexOf(34) != -1 ? 39 : 34;
            this.writer.write(quote);
            this.writer.write(this.doctypePublic);
            this.writer.write(quote);
            this.writer.write(32);
            quote = this.doctypeSystem.indexOf(34) != -1 ? 39 : 34;
            this.writer.write(quote);
            this.writer.write(this.doctypeSystem);
            this.writer.write(quote);
        } else {
            this.writer.write(" SYSTEM ");
            int quote = this.doctypeSystem.indexOf(34) != -1 ? 39 : 34;
            this.writer.write(quote);
            this.writer.write(this.doctypeSystem);
            this.writer.write(quote);
        }
        this.writer.write(" >");
    }

    protected void writeTree(Node node) throws IOException {
        boolean doWriteDTD = false;
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: {
                if (this.doctypeSystem != null && this.doctypeSystem.length() > 0) {
                    this.writeDTD((Document)node);
                    doWriteDTD = true;
                }
            }
            case 11: {
                Node child = node.getFirstChild();
                if (node == this.root && !doWriteDTD) {
                    this.firstDocChild = child;
                }
                while (child != null) {
                    this.writeTree(child);
                    child = child.getNextSibling();
                }
                break;
            }
            case 1: {
                if (node != this.root && node != this.firstDocChild) {
                    this.injectWhitespace(node);
                }
                this.pushState();
                String xmlSpaceValue = ((Element)node).getAttribute("xml:space");
                if (xmlSpaceValue != null && xmlSpaceValue.length() > 0) {
                    this.xmlSpace = xmlSpaceValue.equals("preserve") ? 1 : 0;
                }
                this.cdataOutput = this.useCdataOutput((Element)node);
                this.writer.write("<");
                this.writer.write(node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    this.writeTree(attr);
                }
                Node child = node.getFirstChild();
                if (child != null) {
                    short type;
                    this.writer.write(">");
                    Node lastChild = child;
                    while (child != null) {
                        ++this.indentLevel;
                        this.writeTree(child);
                        --this.indentLevel;
                        lastChild = child;
                        child = child.getNextSibling();
                    }
                    if (this.indent && this.xmlSpace != 1 && (type = lastChild.getNodeType()) != 3 && type != 4) {
                        this.writer.write(10);
                        for (int i = 0; i < this.indentLevel; ++i) {
                            this.writer.write(this.indentString);
                        }
                    }
                    this.writer.write("</");
                    this.writer.write(node.getNodeName());
                    this.writer.write(">");
                } else {
                    this.writer.write("/>");
                }
                this.popState();
                break;
            }
            case 2: {
                this.writer.write(" ");
                this.writer.write(node.getNodeName());
                this.writer.write("=");
                XMLUtil.encodeAttribute(this.writer, node.getNodeValue());
                break;
            }
            case 3: {
                this.injectWhitespace(node);
                if (this.cdataOutput) {
                    XMLUtil.encodeAsCData(this.writer, node.getNodeValue());
                    break;
                }
                if (this.disableTextEscaping) {
                    this.writer.write(node.getNodeValue());
                    break;
                }
                XMLUtil.encodeText(this.writer, node.getNodeValue());
                break;
            }
            case 4: {
                this.injectWhitespace(node);
                XMLUtil.encodeAsCData(this.writer, node.getNodeValue());
                break;
            }
            case 7: {
                this.injectWhitespace(node);
                this.writer.write("<?");
                this.writer.write(node.getNodeName());
                String target = node.getNodeValue();
                if (target != null && target.length() > 0) {
                    this.writer.write(" ");
                    this.writer.write(node.getNodeValue());
                }
                this.writer.write("?>");
                break;
            }
            case 8: {
                this.injectWhitespace(node);
                this.writer.write("<!--");
                this.writer.write(node.getNodeValue());
                this.writer.write("-->");
                break;
            }
        }
    }

    protected void injectWhitespace(Node node) throws IOException {
        if (!this.indent || this.xmlSpace == 1) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: 
            case 7: 
            case 8: {
                short type;
                Node sibling = node.getPreviousSibling();
                if (sibling != null && ((type = sibling.getNodeType()) == 3 || type == 4)) break;
                this.writer.write(10);
                for (int i = 0; i < this.indentLevel; ++i) {
                    this.writer.write(this.indentString);
                }
                break;
            }
        }
    }

    protected boolean useCdataOutput(Element element) {
        if (this.cdataSectionElements == null || this.cdataSectionElements.isEmpty()) {
            return false;
        }
        return this.cdataSectionElements.contains(DOMUtil.getExpandedName(element));
    }

    protected void pushState() {
        this.stack.push(this.cdataOutput ? Boolean.TRUE : Boolean.FALSE);
        this.stack.push(this.xmlSpace == 0 ? xmlSpaceDefault : xmlSpacePreserve);
    }

    protected void popState() {
        this.xmlSpace = (Integer)this.stack.pop();
        this.cdataOutput = (Boolean)this.stack.pop();
    }
}

