/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.dom.AttrImpl;
import com.novell.xml.dom.CDATASectionImpl;
import com.novell.xml.dom.CommentImpl;
import com.novell.xml.dom.DOMExceptionImpl;
import com.novell.xml.dom.DOMImplementationImpl;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.DocumentFragmentImpl;
import com.novell.xml.dom.DocumentTypeImpl;
import com.novell.xml.dom.ElementImpl;
import com.novell.xml.dom.EntityImpl;
import com.novell.xml.dom.EntityReferenceImpl;
import com.novell.xml.dom.NamespaceImpl;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.dom.NotationImpl;
import com.novell.xml.dom.ProcessingInstructionImpl;
import com.novell.xml.dom.TagNameNodeList;
import com.novell.xml.dom.TagNameNodeListEx;
import com.novell.xml.dom.TextImpl;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.XMLUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends NodeImpl
implements Document {
    private DocumentTypeImpl docType;
    private boolean locked = false;
    private Map idMap;
    private boolean doCheckNames = true;
    private int orderChangeCount = -1;
    private boolean smartNS = true;
    private boolean levelOneNodes = false;

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public DocumentImpl getOwnerDocumentEx() {
        return null;
    }

    public DocumentType getDoctype() {
        return this.docType;
    }

    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public Element getDocumentElement() {
        return this.getDocumentElementEx();
    }

    public ElementImpl getDocumentElementEx() {
        NodeImpl node;
        for (node = (NodeImpl)this.getFirstChild(); node != null && node.getNodeType() != 1; node = (NodeImpl)node.getNextSibling()) {
        }
        return (ElementImpl)node;
    }

    public Element createElement(String tagName) throws DOMException {
        this.checkName(tagName);
        this.levelOneNodes = true;
        return new ElementImpl(this, tagName);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        NamespaceName namespaceName = namespaceURI == null ? NamespaceName.NULL_NAMESPACE : new NamespaceName(namespaceURI);
        this.checkNameNS(namespaceName, qualifiedName, false);
        return new ElementImpl(this, namespaceName, qualifiedName);
    }

    public ElementImpl createElementEx(ExpandedQName qName) throws DOMException {
        this.checkNameEx(qName, false);
        return new ElementImpl(this, qName);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public DocumentFragmentImpl createDocumentFragmentEx() {
        return new DocumentFragmentImpl(this);
    }

    public Text createTextNode(String data) {
        return new TextImpl(this, data);
    }

    public TextImpl createTextNodeEx(String data) {
        return new TextImpl(this, data);
    }

    public Comment createComment(String data) {
        return new CommentImpl(this, data);
    }

    public CommentImpl createCommentEx(String data) {
        return new CommentImpl(this, data);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return new CDATASectionImpl(this, data);
    }

    public CDATASectionImpl createCDATASectionEx(String data) throws DOMException {
        return new CDATASectionImpl(this, data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return this.createProcessingInstructionEx(target, data);
    }

    public ProcessingInstructionImpl createProcessingInstructionEx(String target, String data) throws DOMException {
        if (this.checkNames()) {
            this.checkName(target);
            if ("XML".equalsIgnoreCase(target) || data.indexOf("?>") != -1) {
                throw new DOMExceptionImpl(5, null);
            }
        }
        return new ProcessingInstructionImpl(this, target, data);
    }

    public Attr createAttribute(String name) throws DOMException {
        this.checkName(name);
        this.levelOneNodes = true;
        return new AttrImpl(this, name);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        NamespaceName namespaceName = namespaceURI == null ? NamespaceName.NULL_NAMESPACE : new NamespaceName(namespaceURI);
        this.checkNameNS(namespaceName, qualifiedName, true);
        return new AttrImpl(this, namespaceName, qualifiedName);
    }

    public AttrImpl createAttributeEx(ExpandedQName qName) throws DOMException {
        this.checkNameEx(qName, true);
        return new AttrImpl(this, qName);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return this.createEntityReferenceEx(name);
    }

    public EntityReferenceImpl createEntityReferenceEx(String name) throws DOMException {
        this.checkName(name);
        return new EntityReferenceImpl(this, name);
    }

    public NodeList getElementsByTagName(String tagname) {
        return new TagNameNodeList(this, tagname);
    }

    public void setDocumentType(DocumentTypeImpl docType) throws DOMException {
        if (docType.getOwnerDocument() != null) {
            throw new DOMExceptionImpl(4, null);
        }
        this.docType = docType;
        docType.setOwnerDocument(this);
    }

    public Notation createNotation(String name, String publicId, String systemId) {
        return new NotationImpl(this, name, publicId, systemId);
    }

    public Entity createEntity(String name, String publicId, String systemId, String notationName) {
        return new EntityImpl(this, name, publicId, systemId, notationName);
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        NodeImpl newNode = null;
        if (importedNode == null) {
            return null;
        }
        switch (importedNode.getNodeType()) {
            case 1: {
                Element clonedElement;
                boolean sourceDOM2 = importedNode.getOwnerDocument().getImplementation().hasFeature("XML", "2.0");
                Element sourceElement = (Element)importedNode;
                if (!sourceDOM2 || sourceElement.getLocalName() == null) {
                    if (this.smartNS) {
                        NamespaceName nsName = DOMUtil.getNamespaceName(importedNode);
                        String namespaceURI = NamespaceName.NULL_NAMESPACE.equals(nsName) ? null : nsName.getString();
                        clonedElement = this.createElementNS(namespaceURI, sourceElement.getTagName());
                    } else {
                        clonedElement = this.createElement(sourceElement.getTagName());
                    }
                } else {
                    clonedElement = sourceElement instanceof ElementImpl ? this.createElementEx(((ElementImpl)sourceElement).getExpandedName()) : this.createElementNS(sourceElement.getNamespaceURI(), sourceElement.getTagName());
                }
                NamedNodeMap attributes = sourceElement.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr sourceAttr = (Attr)attributes.item(i);
                    Attr clonedAttr = (Attr)this.importNode(sourceAttr, true);
                    if (clonedAttr.getLocalName() != null) {
                        clonedElement.setAttributeNodeNS(clonedAttr);
                        continue;
                    }
                    clonedElement.setAttributeNode(clonedAttr);
                }
                if (deep) {
                    for (Node child = sourceElement.getFirstChild(); child != null; child = child.getNextSibling()) {
                        clonedElement.appendChild(this.importNode(child, deep));
                    }
                }
                newNode = (NodeImpl)((Object)clonedElement);
                break;
            }
            case 2: {
                Attr clonedAttr;
                boolean sourceDOM2 = importedNode.getOwnerDocument().getImplementation().hasFeature("XML", "2.0");
                Attr sourceAttr = (Attr)importedNode;
                if (!sourceDOM2 || sourceAttr.getLocalName() == null) {
                    if (this.smartNS) {
                        NamespaceName nsName;
                        String namespaceURI = XMLUtil.isNamespaceDecl(sourceAttr.getNodeName()) ? NamespaceName.XMLNS_NAMESPACE.getString() : (NamespaceName.NULL_NAMESPACE.equals(nsName = DOMUtil.getNamespaceName(importedNode)) ? null : nsName.getString());
                        clonedAttr = this.createAttributeNS(namespaceURI, sourceAttr.getNodeName());
                    } else {
                        clonedAttr = this.createAttribute(sourceAttr.getNodeName());
                    }
                } else {
                    clonedAttr = sourceAttr instanceof AttrImpl ? this.createAttributeEx(((AttrImpl)sourceAttr).getExpandedName()) : this.createAttributeNS(sourceAttr.getNamespaceURI(), sourceAttr.getNodeName());
                }
                ((AttrImpl)clonedAttr).setSpecified(sourceAttr.getSpecified());
                for (Node child = sourceAttr.getFirstChild(); child != null; child = child.getNextSibling()) {
                    clonedAttr.appendChild(this.importNode(child, deep));
                }
                newNode = (NodeImpl)((Object)clonedAttr);
                break;
            }
            case 3: {
                newNode = (NodeImpl)((Object)this.createTextNode(((Text)importedNode).getData()));
                break;
            }
            case 4: {
                newNode = (NodeImpl)((Object)this.createCDATASection(((CDATASection)importedNode).getData()));
                break;
            }
            case 5: {
                EntityReference clonedEntityRef = this.createEntityReference(importedNode.getNodeName());
                newNode = (NodeImpl)((Object)clonedEntityRef);
                break;
            }
            case 7: {
                newNode = (NodeImpl)((Object)this.createProcessingInstruction(importedNode.getNodeName(), importedNode.getNodeValue()));
                break;
            }
            case 8: {
                newNode = (NodeImpl)((Object)this.createComment(importedNode.getNodeValue()));
                break;
            }
            case 11: {
                DocumentFragment clonedFragment = this.createDocumentFragment();
                if (deep) {
                    for (Node child = importedNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                        clonedFragment.appendChild(this.importNode(child, deep));
                    }
                }
                newNode = (NodeImpl)((Object)clonedFragment);
                break;
            }
            case 6: {
                Entity sourceEntity = (Entity)importedNode;
                Entity clonedEntity = this.createEntity(sourceEntity.getNodeName(), sourceEntity.getPublicId(), sourceEntity.getSystemId(), sourceEntity.getNotationName());
                if (deep) {
                    ((NodeImpl)((Object)clonedEntity)).setDeepReadOnly(false);
                    for (Node child = importedNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                        clonedEntity.appendChild(this.importNode(child, deep));
                    }
                    ((NodeImpl)((Object)clonedEntity)).setDeepReadOnly(true);
                }
                newNode = (NodeImpl)((Object)clonedEntity);
                break;
            }
            case 12: {
                Notation sourceNotation = (Notation)importedNode;
                newNode = (NodeImpl)((Object)this.createNotation(sourceNotation.getNodeName(), sourceNotation.getPublicId(), sourceNotation.getSystemId()));
                break;
            }
            default: {
                throw new DOMExceptionImpl(9, null);
            }
        }
        if (importedNode instanceof NodeImpl) {
            NodeImpl importedNodeImpl = (NodeImpl)importedNode;
            boolean saveReadOnly = newNode.isReadOnly();
            newNode.setReadOnly(false);
            newNode.setBaseURI(importedNodeImpl.getBaseURI());
            newNode.setLineNumber(importedNodeImpl.getLineNumber());
            newNode.setColumnNumber(importedNodeImpl.getColumnNumber());
            newNode.setReadOnly(saveReadOnly);
        }
        return newNode;
    }

    public Node renameNode(Node node, String namespaceURI, String qualifiedName) throws DOMException {
        return this.renameNodeEx(node, DocumentImpl.constructExpandedQName(namespaceURI, qualifiedName));
    }

    public NodeImpl renameNodeEx(Node node, ExpandedQName name) throws DOMException {
        if (node.getOwnerDocument() != this) {
            throw new DOMExceptionImpl(4, null);
        }
        switch (node.getNodeType()) {
            case 1: {
                this.checkNameEx(name, false);
                ((ElementImpl)node).setExpandedName(name);
                break;
            }
            case 2: {
                this.checkNameEx(name, true);
                Element ownerElement = ((AttrImpl)node).getOwnerElement();
                ownerElement.removeAttributeNode((Attr)node);
                ((AttrImpl)node).setExpandedName(name);
                ownerElement.setAttributeNode((Attr)node);
                break;
            }
            default: {
                throw new DOMExceptionImpl(9, null);
            }
        }
        return (NodeImpl)node;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new TagNameNodeListEx(this, DocumentImpl.constructExpandedQName(namespaceURI, localName));
    }

    public NodeList getElementsByTagNameEx(ExpandedQName qName) {
        return new TagNameNodeListEx(this, qName);
    }

    public Element getElementById(String elementId) {
        return this.findElementById(elementId);
    }

    public NamespaceImpl createNamespaceNode(String prefix, String uri) {
        return new NamespaceImpl(this, prefix, uri);
    }

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setCheckNames(boolean enable) {
        this.doCheckNames = enable;
    }

    public void setSmartNS(boolean enable) {
        this.smartNS = enable;
    }

    public boolean getSmartNS() {
        return this.smartNS;
    }

    public boolean isOrderCurrent() {
        return this.orderChangeCount == this.changeCount;
    }

    public void setOrderCurrent(boolean orderIsCurrent) {
        this.orderChangeCount = orderIsCurrent ? this.changeCount : -1;
    }

    public void updateDocumentOrder() {
        if (this.orderChangeCount == this.changeCount) {
            return;
        }
        NodeImpl current = this;
        int order = 0;
        block0: while (current != null) {
            current.setDocumentOrder(order++);
            if (current.getNodeType() == 1) {
                order = ((ElementImpl)current).updateDocumentOrder(order);
            }
            if (current.hasChildNodes()) {
                current = (NodeImpl)current.getFirstChild();
                continue;
            }
            if (current.getNextSibling() != null) {
                current = (NodeImpl)current.getNextSibling();
                continue;
            }
            do {
                if ((current = (NodeImpl)current.getParentNode()) == null || current.getNextSibling() == null) continue;
                current = (NodeImpl)current.getNextSibling();
                continue block0;
            } while (current != null);
        }
        this.setOrderCurrent(true);
    }

    public static DocumentImpl newDocument() {
        return new DocumentImpl();
    }

    public void addId(ElementImpl element, String id) {
        if (this.idMap == null) {
            this.idMap = new HashMap();
        } else if (this.idMap.containsKey(id)) {
            this.idMap.remove(id);
        }
        this.idMap.put(id, element);
        element.setMapped(true);
    }

    public void removeId(String id) {
        ElementImpl element;
        if (this.idMap != null && (element = (ElementImpl)this.idMap.remove(id)) != null) {
            element.setMapped(false);
        }
    }

    public ElementImpl findElementById(String id) {
        if (this.idMap != null) {
            return (ElementImpl)this.idMap.get(id);
        }
        return null;
    }

    protected DocumentImpl() {
        super(null);
        this.document = this;
    }

    protected boolean checkNames() {
        return this.doCheckNames;
    }

    protected boolean anyLevelOneNodes() {
        return this.levelOneNodes;
    }

    public static String constructMessage(String key, Object[] parms) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.novell.xml.dom.DOMImpl_messages");
        try {
            key = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
        return parms == null ? key : MessageFormat.format(key, parms);
    }
}

