/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.dom.NodeImpl;
import java.util.Comparator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DocumentOrderComparator
implements Comparator {
    public int compare(Object o1, Object o2) {
        if (o1 instanceof NodeImpl) {
            return ((NodeImpl)o1).compareTo(o2);
        }
        return DocumentOrderComparator.longCompare(o1, o2);
    }

    public static int longCompare(Object o1, Object o2) {
        Node parent2;
        Node parent1;
        Node n;
        Node node1 = (Node)o1;
        Node node2 = (Node)o2;
        Document doc1 = node1.getOwnerDocument();
        doc1 = doc1 == null ? (Document)node1 : doc1;
        Document doc2 = node2.getOwnerDocument();
        Document document = doc2 = doc2 == null ? (Document)node2 : doc2;
        if (doc1 != doc2) {
            return DocumentOrderComparator.compareDocs(doc1, doc2);
        }
        if (node1.equals(node2)) {
            return 0;
        }
        int depth1 = 0;
        int depth2 = 0;
        for (n = node1.getParentNode(); n != null; n = n.getParentNode()) {
            ++depth1;
        }
        for (n = node2.getParentNode(); n != null; n = n.getParentNode()) {
            ++depth2;
        }
        if (depth1 > depth2) {
            do {
                node1 = node1.getParentNode();
            } while (--depth1 > depth2);
            if (node1.equals(node2)) {
                return 1;
            }
        } else if (depth2 > depth1) {
            do {
                node2 = node2.getParentNode();
            } while (--depth2 > depth1);
            if (node2.equals(node1)) {
                return -1;
            }
        }
        while ((parent1 = node1.getParentNode()) != (parent2 = node2.getParentNode())) {
            node1 = parent1;
            node2 = parent2;
        }
        if (parent1 == null) {
            return node1.hashCode() - node2.hashCode();
        }
        short node1Type = node1.getNodeType();
        short node2Type = node2.getNodeType();
        if (node1Type == 2 || node1Type < 0) {
            if (node2Type == 2 || node2Type < 0) {
                return node1.getNodeName().compareTo(node2.getNodeName());
            }
            return -1;
        }
        if (node2Type == 2 || node2Type < 0) {
            return 1;
        }
        Node sibling = parent1.getFirstChild();
        while (sibling != node1) {
            if (sibling == node2) {
                return 1;
            }
            sibling = sibling.getNextSibling();
        }
        return -1;
    }

    protected static int compareDocs(Document doc1, Document doc2) {
        Node node1 = doc1.getDocumentElement();
        Node node2 = doc2.getDocumentElement();
        while (node1 != null || node2 != null) {
            if (node1 != null && node2 == null) {
                return -1;
            }
            if (node1 == null && node2 != null) {
                return 1;
            }
            int result = node1.getNodeName().compareTo(node2.getNodeName());
            if (result != 0) {
                return result;
            }
            Node temp1 = node1.getNextSibling();
            Node temp2 = node2.getNextSibling();
            if (temp1 == null && temp2 == null) {
                node1 = node1.getFirstChild();
                node2 = node2.getFirstChild();
                continue;
            }
            node1 = temp1;
            node2 = temp2;
        }
        return doc1.hashCode() - doc2.hashCode();
    }
}

