/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.dom.AttrImpl;
import com.novell.xml.dom.DOMExceptionImpl;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.dom.NamedNodeMapImpl;
import com.novell.xml.dom.NamespaceImpl;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.dom.TagNameNodeList;
import com.novell.xml.dom.TagNameNodeListEx;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementImpl
extends NodeImpl
implements Element {
    private NamedNodeMapImpl attributes = null;
    private NamedNodeMapImpl namespaces = null;
    private boolean isMapped = false;
    private AttrImpl idAttr = null;

    public short getNodeType() {
        return 1;
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public NamedNodeMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = new NamedNodeMapImpl(this);
        }
        return this.attributes;
    }

    public Node cloneNode(boolean deep) {
        ElementImpl dolly = (ElementImpl)super.cloneNode(deep);
        if (this.attributes != null) {
            dolly.attributes = this.attributes.cloneThis(dolly);
        }
        return dolly;
    }

    public String getAttribute(String name) {
        Attr attr = this.attributes != null ? (Attr)this.attributes.getNamedItem(name) : null;
        return attr == null ? "" : attr.getValue();
    }

    public void setAttribute(String name, String value) throws DOMException {
        this.gateModify();
        this.checkName(name);
        if (this.attributes == null) {
            this.attributes = new NamedNodeMapImpl(this);
        }
        AttrImpl attr = (AttrImpl)this.getOwnerDocument().createAttribute(name);
        attr.setNodeValue(value);
        this.setAttributeNode(attr);
        this.document.setOrderCurrent(false);
    }

    public void removeAttribute(String name) throws DOMException {
        block3: {
            this.gateModify();
            if (this.attributes != null) {
                Attr attr = null;
                try {
                    attr = (Attr)this.attributes.removeNamedItem(name);
                }
                catch (DOMException de) {
                    if (de.code == 8) break block3;
                    throw de;
                }
            }
        }
    }

    public Attr getAttributeNode(String name) {
        return this.attributes == null ? null : (Attr)this.attributes.getNamedItem(name);
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        this.gateModify();
        if (this.attributes == null) {
            this.attributes = new NamedNodeMapImpl(this);
        }
        this.document.setOrderCurrent(false);
        return (Attr)this.attributes.setNamedItem(newAttr);
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        this.gateModify();
        if (this.attributes != null) {
            Attr attr = (Attr)this.attributes.removeNamedItem(oldAttr.getNodeName());
            return attr;
        }
        throw new DOMExceptionImpl(8, null);
    }

    public NodeList getElementsByTagName(String name) {
        return new TagNameNodeList(this, name);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeEx(ElementImpl.constructExpandedQName(namespaceURI, localName));
    }

    public String getAttributeEx(ExpandedQName qName) {
        AttrImpl attr = null;
        if (this.attributes != null) {
            attr = (AttrImpl)this.attributes.getNamedItemEx(qName);
        }
        return attr == null ? "" : attr.getValue();
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        this.setAttributeEx(ElementImpl.constructExpandedQName(namespaceURI, qualifiedName), value);
    }

    public void setAttributeEx(ExpandedQName qName, String value) throws DOMException {
        this.gateModify();
        if (this.attributes == null) {
            this.attributes = new NamedNodeMapImpl(this);
        }
        AttrImpl attr = ((DocumentImpl)this.getOwnerDocument()).createAttributeEx(qName);
        attr.setNodeValue(value);
        this.setAttributeNodeNS(attr);
        this.document.setOrderCurrent(false);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        this.removeAttributeEx(ElementImpl.constructExpandedQName(namespaceURI, localName));
    }

    public void removeAttributeEx(ExpandedQName qName) throws DOMException {
        block3: {
            this.gateModify();
            if (this.attributes != null) {
                try {
                    this.attributes.removeNamedItemEx(qName);
                }
                catch (DOMException de) {
                    if (de.code == 8) break block3;
                    throw de;
                }
            }
        }
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.getAttributeNodeEx(ElementImpl.constructExpandedQName(namespaceURI, localName));
    }

    public AttrImpl getAttributeNodeEx(ExpandedQName qName) {
        return this.attributes == null ? null : (AttrImpl)this.attributes.getNamedItemEx(qName);
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return this.setAttributeNodeEx(newAttr);
    }

    public AttrImpl setAttributeNodeEx(Attr newAttr) throws DOMException {
        this.gateModify();
        if (this.attributes == null) {
            this.attributes = new NamedNodeMapImpl(this);
        }
        this.document.setOrderCurrent(false);
        return (AttrImpl)this.attributes.setNamedItemNS(newAttr);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new TagNameNodeListEx(this, ElementImpl.constructExpandedQName(namespaceURI, localName));
    }

    public NodeList getElementsByTagNameEx(ExpandedQName qName) {
        return new TagNameNodeListEx(this, qName);
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.hasAttributeEx(ElementImpl.constructExpandedQName(namespaceURI, localName));
    }

    public boolean hasAttributeEx(ExpandedQName qName) {
        return this.getAttributeNodeEx(qName) != null;
    }

    public Attr getIdAttr() {
        return this.idAttr;
    }

    public NamedNodeMap getNamespaces() {
        if (this.namespaces == null) {
            this.namespaces = new NamedNodeMapImpl(this);
            DocumentImpl document = (DocumentImpl)this.getOwnerDocument();
            for (Node parent = this; parent != null; parent = parent.getParentNode()) {
                Attr attr;
                NamedNodeMap attrs = parent.getAttributes();
                if (attrs == null) continue;
                int i = 0;
                while ((attr = (Attr)attrs.item(i++)) != null) {
                    String name = attr.getNodeName();
                    if (!XMLUtil.isNamespaceDecl(name)) continue;
                    int index = name.indexOf(58);
                    String uri = attr.getNodeValue();
                    NamespaceImpl ns = document.createNamespaceNode(index == -1 ? "" : name.substring(index + 1, name.length()), uri);
                    this.namespaces.setNamedItemConditional(ns, false);
                }
            }
            if (this.namespaces.getLength() != 0) {
                NodeImpl node;
                double startOrder = this.getDocumentOrder();
                double endOrder = this.attributes == null || this.attributes.item(0) == null ? startOrder + 1.0 : ((NodeImpl)this.attributes.item(0)).getDocumentOrder() - startOrder;
                double delta = (endOrder - startOrder) / (double)(this.namespaces.getLength() + 1);
                startOrder += delta;
                int i = 0;
                while ((node = (NodeImpl)this.namespaces.item(i++)) != null) {
                    node.setDocumentOrder(startOrder);
                    startOrder += delta;
                }
            }
        }
        return this.namespaces;
    }

    protected int updateDocumentOrder(int order) {
        NodeImpl node;
        int i;
        if (this.namespaces != null) {
            i = 0;
            while ((node = (NodeImpl)this.namespaces.item(i++)) != null) {
                node.setDocumentOrder(order++);
            }
        }
        if (this.attributes != null) {
            i = 0;
            while ((node = (NodeImpl)this.attributes.item(i++)) != null) {
                node.setDocumentOrder(order++);
            }
        }
        return order;
    }

    protected ElementImpl(DocumentImpl owner, String tagName) {
        super(owner, tagName);
    }

    protected ElementImpl(DocumentImpl owner, NamespaceName namespaceName, String qualifiedName) {
        super(owner, namespaceName, qualifiedName);
    }

    protected ElementImpl(DocumentImpl owner, ExpandedQName qName) {
        super(owner, qName);
    }

    protected void setMapped(boolean isMapped) {
        this.isMapped = isMapped;
    }

    protected void checkNamespaceAttr(String attrName) {
        this.incChangeCount();
        if (this.document.anyLevelOneNodes() && XMLUtil.isNamespaceDecl(attrName)) {
            this.purgeCachedExpandedNames();
        }
    }

    protected void purgeCachedExpandedNames() {
        super.purgeCachedExpandedNames();
        this.namespaces = null;
        if (this.attributes != null) {
            int i = 0;
            AttrImpl attr = (AttrImpl)this.attributes.item(i);
            while (attr != null) {
                attr.purgeCachedExpandedNames();
                attr = (AttrImpl)this.attributes.item(++i);
            }
        }
    }
}

