/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.dom.AttrImpl;
import com.novell.xml.dom.DOMExceptionImpl;
import com.novell.xml.dom.ElementImpl;
import com.novell.xml.dom.NamespaceImpl;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.util.ExpandedQName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap {
    private List nodeList = new ArrayList(1);
    private boolean needSort = false;
    private NodeImpl owner;
    private static NameComparator nameComparator = new NameComparator();

    public Node getNamedItem(String name) {
        int index = this.findItem(name);
        if (index >= 0) {
            return (Node)this.nodeList.get(index);
        }
        return null;
    }

    public Node setNamedItem(Node arg) throws DOMException {
        return this.setNamedItemConditional(arg, true);
    }

    Node setNamedItemConditional(Node arg, boolean replace) {
        if (arg.getOwnerDocument() != this.owner.getOwnerDocument()) {
            throw new DOMExceptionImpl(4, null);
        }
        this.owner.gateModify();
        if (arg.getNodeType() == 2 && ((AttrImpl)arg).isInUse() && ((AttrImpl)arg).getOwnerElement() != this.owner) {
            throw new DOMExceptionImpl(10, null);
        }
        int index = this.findItem(arg.getNodeName());
        if (index >= 0) {
            Node ret = null;
            if (replace) {
                ret = (Node)this.nodeList.get(index);
                this.removeNode(ret);
                this.nodeList.set(index, arg);
                this.addNode(arg);
            }
            return ret;
        }
        this.nodeList.add(arg);
        this.addNode(arg);
        this.needSort = true;
        return null;
    }

    public Node removeNamedItem(String name) throws DOMException {
        this.owner.gateModify();
        int index = this.findItem(name);
        if (index >= 0) {
            Node node = (Node)this.nodeList.remove(index);
            this.removeNode(node);
            return node;
        }
        throw new DOMExceptionImpl(8, null);
    }

    public Node item(int index) {
        if (0 > index || index >= this.nodeList.size()) {
            return null;
        }
        if (this.needSort) {
            this.sort();
        }
        return (Node)this.nodeList.get(index);
    }

    public int getLength() {
        return this.nodeList.size();
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        return this.getNamedItemEx(NodeImpl.constructExpandedQName(namespaceURI, localName));
    }

    public NodeImpl getNamedItemEx(ExpandedQName qName) {
        int index = this.findItemEx(qName);
        if (index >= 0) {
            return (NodeImpl)this.nodeList.get(index);
        }
        return null;
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        if (arg == null) {
            return null;
        }
        if (arg.getOwnerDocument() != this.owner.getOwnerDocument()) {
            throw new DOMExceptionImpl(4, null);
        }
        this.owner.gateModify();
        if (arg.getNodeType() == 2 && ((AttrImpl)arg).isInUse() && ((AttrImpl)arg).getOwnerElement() != this.owner) {
            throw new DOMExceptionImpl(10, null);
        }
        int index = this.findItemEx(((NodeImpl)arg).getExpandedName());
        if (index >= 0) {
            Node ret = (Node)this.nodeList.get(index);
            this.removeNode(ret);
            this.nodeList.set(index, arg);
            this.addNode(arg);
            return ret;
        }
        this.nodeList.add(arg);
        this.addNode(arg);
        this.needSort = true;
        return null;
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        return this.removeNamedItemEx(NodeImpl.constructExpandedQName(namespaceURI, localName));
    }

    public Node removeNamedItemEx(ExpandedQName qName) {
        this.owner.gateModify();
        int index = this.findItemEx(qName);
        if (index >= 0) {
            Node node = (Node)this.nodeList.remove(index);
            this.removeNode(node);
            return node;
        }
        throw new DOMExceptionImpl(8, null);
    }

    public NamedNodeMapImpl cloneThis(NodeImpl clonedOwner) {
        NamedNodeMapImpl dolly = new NamedNodeMapImpl(clonedOwner);
        int len = this.nodeList.size();
        dolly.needSort = this.needSort;
        for (int i = 0; i < len; ++i) {
            dolly.nodeList.add(((Node)this.nodeList.get(i)).cloneNode(true));
        }
        return dolly;
    }

    protected NamedNodeMapImpl(NodeImpl owner) {
        this.owner = owner;
    }

    protected void sort() {
        Collections.sort(this.nodeList, nameComparator);
        this.needSort = false;
    }

    protected int findItem(String name) {
        if (this.needSort) {
            this.sort();
        }
        return Collections.binarySearch(this.nodeList, name, nameComparator);
    }

    protected int findItemEx(ExpandedQName qName) {
        int l = this.nodeList.size();
        for (int i = 0; i < l; ++i) {
            NodeImpl node = (NodeImpl)this.nodeList.get(i);
            if (!node.getExpandedName().equals(qName)) continue;
            return i;
        }
        return -1;
    }

    protected void removeNode(Node node) {
        if (this.owner.getNodeType() == 1) {
            short type = node.getNodeType();
            if (type == 2) {
                if (((AttrImpl)node).isId() && this.owner.document != null) {
                    this.owner.document.removeId(node.getNodeValue());
                }
                ((AttrImpl)node).setOwningElement(null);
                this.checkNamespaceAttr((AttrImpl)node);
            } else if (type == -1) {
                ((NamespaceImpl)node).setOwningElement(null);
            }
        }
    }

    protected void addNode(Node node) {
        if (this.owner.getNodeType() == 1) {
            short type = node.getNodeType();
            if (type == 2) {
                if (((AttrImpl)node).isId() && this.owner.document != null) {
                    this.owner.document.addId((ElementImpl)this.owner, node.getNodeValue());
                }
                ((AttrImpl)node).setOwningElement((ElementImpl)this.owner);
                this.checkNamespaceAttr((AttrImpl)node);
            } else if (type == -1) {
                ((NamespaceImpl)node).setOwningElement((ElementImpl)this.owner);
            }
        }
    }

    protected void checkNamespaceAttr(AttrImpl attr) {
        ((ElementImpl)this.owner).checkNamespaceAttr(attr.getNodeName());
    }

    private static class NameComparator
    implements Comparator {
        private NameComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null) {
                if (o1 == null) {
                    return o2 == null ? 0 : -1;
                }
                if (o2 == null) {
                    return 1;
                }
            } else {
                if (o1 instanceof String) {
                    return ((String)o1).compareTo(((Node)o2).getNodeName());
                }
                if (o2 instanceof String) {
                    return ((Node)o1).getNodeName().compareTo((String)o2);
                }
            }
            return ((Node)o1).getNodeName().compareTo(((Node)o2).getNodeName());
        }

        public boolean equals(Object o) {
            return this == o;
        }
    }
}

