/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.dom.ChildNodeList;
import com.novell.xml.dom.DOMExceptionImpl;
import com.novell.xml.dom.DOMImplementationImpl;
import com.novell.xml.dom.DOMWriter;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.dom.DocumentOrderComparator;
import com.novell.xml.dom.ElementImpl;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.MutableExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.XMLUtil;
import java.io.IOException;
import java.io.StringWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class NodeImpl
implements Node,
Cloneable,
Comparable {
    private static final String TAG_WILDCARD = "*";
    private String nodeName = null;
    private ExpandedQName expandedName = null;
    protected int changeCount = 0;
    protected DocumentImpl document = null;
    protected NodeImpl parentNode = null;
    protected NodeImpl firstChild = null;
    protected NodeImpl lastChild = null;
    protected NodeImpl nextSibling = null;
    protected NodeImpl previousSibling = null;
    protected double documentOrderVal = nextOrderVal += 1.0;
    protected static double nextOrderVal = 2.147483647E9;
    private boolean readonly = false;
    protected String baseURI = null;
    private int line;
    private int column;
    protected static int[] allowedChildren = new int[13];
    protected static final String xmlPrefix = "xml";
    protected static final String xmlnsPrefix = "xmlns";
    public static boolean toStringSerializes;

    public String getNodeName() {
        if (this.expandedName == null) {
            return this.nodeName;
        }
        return this.getExpandedName().getQName();
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
    }

    public abstract short getNodeType();

    public Node getParentNode() {
        return this.parentNode;
    }

    public NodeImpl getParentNodeEx() {
        return this.parentNode;
    }

    public NodeList getChildNodes() {
        return new ChildNodeList(this);
    }

    public Node getFirstChild() {
        return this.firstChild;
    }

    public NodeImpl getFirstChildEx() {
        return this.firstChild;
    }

    public Node getLastChild() {
        return this.lastChild;
    }

    public NodeImpl getLastChildEx() {
        return this.lastChild;
    }

    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    public NodeImpl getPreviousSiblingEx() {
        return this.previousSibling;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public NodeImpl getNextSiblingEx() {
        return this.nextSibling;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return this.document;
    }

    public DocumentImpl getOwnerDocumentEx() {
        return this.document;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        Node parent;
        this.gateModify();
        if (newChild == null || !(newChild instanceof NodeImpl) || newChild.getOwnerDocument() != this.document) {
            System.err.println("newChild: " + newChild + " " + newChild.getOwnerDocument() + " : " + this.document);
            throw new DOMExceptionImpl(4, null);
        }
        if (refChild != null && ((parent = refChild.getParentNode()) == null || parent != this)) {
            throw new DOMExceptionImpl(8, null);
        }
        if (newChild.getNodeType() == 11) {
            Node fragChild;
            for (fragChild = newChild.getFirstChild(); fragChild != null; fragChild = fragChild.getNextSibling()) {
                if (this.isChildAllowed(fragChild)) continue;
                throw new DOMExceptionImpl(3, null);
            }
            while ((fragChild = newChild.getFirstChild()) != null) {
                this.insertBefore(fragChild, refChild);
            }
        } else {
            Attr idAttr;
            NodeImpl after;
            Node ancestor;
            if (!this.isChildAllowed(newChild)) {
                throw new DOMExceptionImpl(3, null);
            }
            for (ancestor = this.getParentNode(); ancestor != null; ancestor = ancestor.getParentNode()) {
                if (ancestor != newChild) continue;
                throw new DOMExceptionImpl(3, null);
            }
            NodeImpl newImpl = (NodeImpl)newChild;
            ancestor = newChild.getParentNode();
            if (ancestor != null) {
                ancestor.removeChild(newImpl);
            }
            newImpl.parentNode = this;
            newImpl.previousSibling = after = refChild == null ? this.lastChild : ((NodeImpl)refChild).previousSibling;
            newImpl.nextSibling = (NodeImpl)refChild;
            if (after != null) {
                after.nextSibling = newImpl;
                if (after == this.lastChild) {
                    this.lastChild = newImpl;
                }
            } else {
                this.firstChild = newImpl;
                if (refChild == null) {
                    this.lastChild = newImpl;
                }
            }
            if (refChild != null) {
                ((NodeImpl)refChild).previousSibling = newImpl;
            }
            if (newImpl.getNodeType() == 1 && (idAttr = ((ElementImpl)newImpl).getIdAttr()) != null) {
                this.document.addId((ElementImpl)newImpl, idAttr.getNodeValue());
            }
            if (ancestor == null && this.document.anyLevelOneNodes()) {
                newImpl.purgeCachedExpandedNames();
            }
        }
        this.incChangeCount();
        return newChild;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        this.insertBefore(newChild, oldChild);
        return this.removeChild(oldChild);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        Attr idAttr;
        this.gateModify();
        Node parent = oldChild.getParentNode();
        if (parent == null || parent != this) {
            throw new DOMExceptionImpl(8, null);
        }
        NodeImpl impl = (NodeImpl)oldChild;
        impl.parentNode = null;
        if (this.firstChild == impl) {
            this.firstChild = impl.nextSibling;
        }
        if (this.lastChild == impl) {
            this.lastChild = impl.previousSibling;
        }
        if (impl.previousSibling != null) {
            impl.previousSibling.nextSibling = impl.nextSibling;
        }
        if (impl.nextSibling != null) {
            impl.nextSibling.previousSibling = impl.previousSibling;
        }
        impl.previousSibling = null;
        impl.nextSibling = null;
        this.incChangeCount();
        if (this.document.anyLevelOneNodes()) {
            impl.purgeCachedExpandedNames();
        }
        if (oldChild.getNodeType() == 1 && (idAttr = ((ElementImpl)oldChild).getIdAttr()) != null) {
            this.document.removeId(idAttr.getNodeValue());
        }
        return oldChild;
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.insertBefore(newChild, null);
    }

    public boolean hasChildNodes() {
        return this.firstChild != null;
    }

    public Node cloneNode(boolean deep) {
        NodeImpl dolly;
        try {
            dolly = (NodeImpl)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.toString());
        }
        dolly.parentNode = null;
        dolly.firstChild = null;
        dolly.lastChild = null;
        dolly.previousSibling = null;
        dolly.nextSibling = null;
        dolly.readonly = false;
        this.documentOrderVal = nextOrderVal += 1.0;
        if (deep) {
            for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                dolly.insertBefore(child.cloneNode(true), null);
            }
        }
        return dolly;
    }

    public void normalize() {
        Node child = this.getFirstChild();
        while (child != null) {
            Node nextChild = child.getNextSibling();
            if (child.getNodeType() == 3 && nextChild != null && nextChild.getNodeType() == 3) {
                ((Text)child).appendData(nextChild.getNodeValue());
                this.removeChild(nextChild);
                nextChild = child;
            } else if (child.getNodeType() == 1) {
                NamedNodeMap attrs = ((Element)((Object)this)).getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    attrs.item(i).normalize();
                }
                ((Element)child).normalize();
            }
            child = nextChild;
        }
    }

    public boolean isSupported(String feature, String version) {
        return DOMImplementationImpl.checkFeature(feature, version);
    }

    public String getNamespaceURI() {
        if (this.expandedName == null && !this.document.getSmartNS()) {
            return null;
        }
        NamespaceName namespaceName = this.getExpandedName().getNamespaceName();
        return namespaceName.equals(NamespaceName.NULL_NAMESPACE) || namespaceName.equals(NamespaceName.UNKNOWN_NAMESPACE) ? null : namespaceName.getString();
    }

    public String getPrefix() {
        if (this.expandedName == null && !this.document.getSmartNS() || this.getNodeType() != 1 && this.getNodeType() != 2) {
            return null;
        }
        return this.getExpandedName().getPrefix();
    }

    public void setPrefix(String prefix) throws DOMException {
        this.gateModify();
        switch (this.getNodeType()) {
            case 1: 
            case 2: {
                this.getExpandedName();
                if (this.expandedName == null) break;
                this.checkPrefixNS(this.expandedName.getNamespaceName(), this.expandedName.getLocalPart(), prefix, this.getNodeType() == 2);
                if (!(this.expandedName instanceof MutableExpandedQName)) {
                    this.expandedName = new MutableExpandedQName(this.expandedName);
                }
                ((MutableExpandedQName)this.expandedName).setPrefix(prefix);
                return;
            }
        }
    }

    public String getLocalName() {
        if (this.expandedName == null && !this.document.getSmartNS() || this.getNodeType() != 1 && this.getNodeType() != 2) {
            return null;
        }
        return this.getExpandedName().getLocalPart();
    }

    public boolean hasAttributes() {
        return this.getNodeType() == 1 && ((Element)((Object)this)).getAttributes().getLength() > 0;
    }

    public void setReadOnly(boolean readonly) {
        this.readonly = readonly;
    }

    public void setDeepReadOnly(boolean readonly) {
        this.readonly = readonly;
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ((NodeImpl)child).setDeepReadOnly(readonly);
        }
        NamedNodeMap attrs = this.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                ((NodeImpl)attrs.item(i)).setDeepReadOnly(readonly);
            }
        }
    }

    public boolean isReadOnly() {
        return this.readonly || this.document.isLocked();
    }

    public int compareTo(Object o) {
        int retval;
        if (o instanceof Node) {
            Node that = (Node)o;
            Document thisDocument = this.getOwnerDocument();
            Document thatDocument = that.getOwnerDocument();
            if (thisDocument == null) {
                thisDocument = (Document)((Object)this);
            }
            if (thatDocument == null) {
                thatDocument = (Document)that;
            }
            if (that instanceof NodeImpl && thisDocument == thatDocument) {
                ((DocumentImpl)thisDocument).updateDocumentOrder();
                double delta = this.documentOrderVal - ((NodeImpl)that).documentOrderVal;
                int n = delta < 0.0 ? -1 : (retval = delta > 0.0 ? 1 : 0);
                if (retval == 0 && !this.equals(o)) {
                    retval = DocumentOrderComparator.longCompare(this, o);
                }
            } else {
                retval = DocumentOrderComparator.compareDocs(thisDocument, thatDocument);
            }
        } else {
            throw new ClassCastException();
        }
        return retval;
    }

    public double getDocumentOrder() {
        return this.documentOrderVal;
    }

    public void setDocumentOrder(double documentOrderVal) {
        this.documentOrderVal = documentOrderVal;
    }

    public ExpandedQName getExpandedName() {
        if (this.expandedName == null) {
            short nodeType = this.getNodeType();
            if (nodeType == 2 || nodeType == 1) {
                ExpandedQName qExpandedName = new ExpandedQName(this);
                NamespaceName qNamespaceName = qExpandedName.getNamespaceName();
                if (!qNamespaceName.equals(NamespaceName.UNKNOWN_NAMESPACE)) {
                    String qNodeName = qExpandedName.getQName();
                    String qLocalPart = qExpandedName.getLocalPart();
                    String qPrefix = qExpandedName.getPrefix();
                    if (nodeType == 2 && XMLUtil.isNamespaceDecl(qNodeName)) {
                        qNamespaceName = NamespaceName.XMLNS_NAMESPACE;
                    }
                    try {
                        qPrefix = qPrefix == null || qPrefix.length() == 0 ? null : qPrefix;
                        this.checkNameNS(qNamespaceName, qLocalPart, qPrefix, nodeType == 2);
                        this.expandedName = qExpandedName;
                        this.incChangeCount();
                    }
                    catch (DOMException de) {
                        this.expandedName = new ExpandedQName(NamespaceName.NULL_NAMESPACE, qExpandedName.getQName());
                    }
                } else {
                    this.expandedName = new ExpandedQName(NamespaceName.NULL_NAMESPACE, this.getNodeName());
                }
            } else {
                this.expandedName = new ExpandedQName(NamespaceName.NULL_NAMESPACE, this.getNodeName());
            }
        }
        return this.expandedName;
    }

    protected void setExpandedName(ExpandedQName newName) {
        this.expandedName = newName;
        this.nodeName = null;
    }

    public void setBaseURI(String baseURI) throws DOMException {
        this.gateModify();
        this.baseURI = baseURI;
    }

    public String getBaseURI() {
        if (this.baseURI == null) {
            NodeImpl ancestor = this.parentNode;
            while (ancestor != null && ancestor.baseURI == null) {
                ancestor = ancestor.parentNode;
            }
            return ancestor != null ? ancestor.baseURI : null;
        }
        return this.baseURI;
    }

    public void setColumnNumber(int column) {
        this.column = column;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public void setLineNumber(int line) {
        this.line = line;
    }

    public int getLineNumber() {
        return this.line;
    }

    public String toString() {
        if (toStringSerializes) {
            try {
                StringWriter writer = new StringWriter();
                DOMWriter domWriter = new DOMWriter(this, writer);
                domWriter.write();
                return writer.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.getNodeName() + ',' + this.getNamespaceURI() + ',' + this.getNodeValue();
    }

    protected boolean isChildAllowed(Node checkChild) {
        return (allowedChildren[this.getNodeType()] & 1 << checkChild.getNodeType()) != 0;
    }

    protected void incChangeCount() {
        ++this.changeCount;
        if (this.parentNode != null) {
            this.parentNode.incChangeCount();
        }
    }

    protected int getChangeCount() {
        return this.changeCount;
    }

    protected void gateModify() throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, null);
        }
    }

    protected void checkName(String name) throws DOMException {
        if (this.document.checkNames() && !XMLUtil.isXMLName(name)) {
            throw new DOMExceptionImpl(5, null);
        }
    }

    protected void checkPrefixNS(NamespaceName namespaceName, String localName, String prefix, boolean isAttr) throws DOMException {
        if (!XMLUtil.isNCName(prefix)) {
            throw new DOMExceptionImpl(5, null);
        }
        if (prefix.indexOf(58) != -1) {
            throw new DOMExceptionImpl(14, null);
        }
        if (namespaceName.equals(NamespaceName.NULL_NAMESPACE) || prefix.equals(xmlPrefix) && !namespaceName.equals(NamespaceName.XML_NAMESPACE)) {
            throw new DOMExceptionImpl(14, null);
        }
        if (isAttr && (prefix.equals(xmlnsPrefix) && !namespaceName.equals(NamespaceName.XMLNS_NAMESPACE) || localName.equals(xmlnsPrefix))) {
            throw new DOMExceptionImpl(14, null);
        }
    }

    protected void checkNameNS(NamespaceName namespaceName, String localPart, String prefix, boolean isAttr) throws DOMException {
        if (this.document.checkNames()) {
            if (localPart.length() == 0) {
                throw new DOMExceptionImpl(14, null);
            }
            if (!XMLUtil.isNCName(localPart)) {
                throw new DOMExceptionImpl(5, null);
            }
            if (prefix != null) {
                if (namespaceName == null || namespaceName.equals(NamespaceName.UNKNOWN_NAMESPACE) || namespaceName.equals(NamespaceName.NULL_NAMESPACE)) {
                    throw new DOMExceptionImpl(14, null);
                }
                this.checkPrefixNS(namespaceName, localPart, prefix, isAttr);
            } else if (!(!isAttr || namespaceName == null || namespaceName.equals(NamespaceName.NULL_NAMESPACE) || localPart.equals(xmlnsPrefix) && namespaceName.equals(NamespaceName.XMLNS_NAMESPACE))) {
                throw new DOMExceptionImpl(14, null);
            }
        }
    }

    protected void checkNameNS(NamespaceName namespaceName, String qualifiedName, boolean isAttr) throws DOMException {
        if (this.document.checkNames()) {
            this.checkName(qualifiedName);
            if (!XMLUtil.isQName(qualifiedName)) {
                throw new DOMExceptionImpl(14, null);
            }
            int index = qualifiedName.indexOf(58);
            if (index != -1) {
                this.checkNameNS(namespaceName, qualifiedName.substring(index + 1), qualifiedName.substring(0, index), isAttr);
            } else {
                this.checkNameNS(namespaceName, qualifiedName, null, isAttr);
            }
        }
    }

    protected void checkNameEx(ExpandedQName qName, boolean isAttr) throws DOMException {
        if (this.document.checkNames()) {
            this.checkNameNS(qName.getNamespaceName(), qName.getLocalPart(), qName.getPrefix(), isAttr);
        }
    }

    protected void setOwnerDocument(DocumentImpl owner) throws DOMException {
        if (this.getNodeType() != 10) {
            throw new DOMExceptionImpl(4, null);
        }
        this.document = owner;
    }

    protected void purgeCachedExpandedNames() {
        if (this.nodeName != null) {
            this.expandedName = null;
        }
        NodeImpl child = this.firstChild;
        while (child != null) {
            child.purgeCachedExpandedNames();
            child = child.nextSibling;
        }
    }

    public static ExpandedQName constructExpandedQName(String namespaceURI, String localPart) {
        NamespaceName namespaceName;
        String prefix = null;
        int index = localPart.indexOf(58);
        if (index != -1) {
            prefix = localPart.substring(0, index);
            localPart = localPart.substring(index + 1);
        }
        if (namespaceURI != null && namespaceURI.equals(TAG_WILDCARD)) {
            if (localPart.equals(TAG_WILDCARD)) {
                return ExpandedQName.WILDCARD_QNAME;
            }
            namespaceName = NamespaceName.WILDCARD_NAMESPACE;
        } else {
            NamespaceName namespaceName2 = namespaceName = namespaceURI == null ? NamespaceName.NULL_NAMESPACE : new NamespaceName(namespaceURI);
        }
        if (prefix == null) {
            return new ExpandedQName(namespaceName, localPart);
        }
        return new ExpandedQName(namespaceName, localPart, prefix);
    }

    protected NodeImpl(DocumentImpl owner, String name) {
        this.document = owner == null && this instanceof DocumentImpl ? (DocumentImpl)this : owner;
        this.nodeName = name;
    }

    protected NodeImpl(DocumentImpl owner) {
        this.document = owner == null && this instanceof DocumentImpl ? (DocumentImpl)this : owner;
        this.expandedName = new ExpandedQName(NamespaceName.NULL_NAMESPACE, "", "");
    }

    protected NodeImpl(DocumentImpl owner, NamespaceName namespaceName, String qualifiedName) {
        this.document = owner == null && this instanceof DocumentImpl ? (DocumentImpl)this : owner;
        int index = qualifiedName.indexOf(58);
        this.expandedName = index != -1 ? new ExpandedQName(namespaceName, qualifiedName.substring(index + 1), qualifiedName.substring(0, index)) : new ExpandedQName(namespaceName, qualifiedName);
    }

    protected NodeImpl(DocumentImpl owner, ExpandedQName qName) {
        DocumentImpl documentImpl = this.document = owner == null && this instanceof DocumentImpl ? (DocumentImpl)this : owner;
        if (qName == null) {
            throw new IllegalArgumentException("qName must not be null");
        }
        this.expandedName = qName;
    }

    static {
        NodeImpl.allowedChildren[1] = 442;
        NodeImpl.allowedChildren[2] = 40;
        NodeImpl.allowedChildren[3] = 0;
        NodeImpl.allowedChildren[4] = 0;
        NodeImpl.allowedChildren[5] = allowedChildren[1];
        NodeImpl.allowedChildren[6] = allowedChildren[1];
        NodeImpl.allowedChildren[7] = 0;
        NodeImpl.allowedChildren[8] = 0;
        NodeImpl.allowedChildren[9] = 410;
        NodeImpl.allowedChildren[10] = 0;
        NodeImpl.allowedChildren[11] = allowedChildren[1];
        NodeImpl.allowedChildren[12] = 0;
        toStringSerializes = false;
    }
}

