/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.xpath.NamespaceContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StringNamespaceContext
implements NamespaceContext {
    private Map namespaceMap = new HashMap();

    StringNamespaceContext(List namespaceList) throws IllegalArgumentException {
        try {
            Iterator it = namespaceList.iterator();
            while (it.hasNext()) {
                String prefix = (String)it.next();
                if (!it.hasNext()) {
                    throw new IllegalArgumentException("Entries in namespace list must come in prefix/URI pairs");
                }
                String uri = (String)it.next();
                this.namespaceMap.put(prefix, new NamespaceName(uri));
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Entries in namespace list must be strings");
        }
    }

    StringNamespaceContext(String[] namespaceArray) throws IllegalArgumentException {
        int len = namespaceArray.length;
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Entries in namespace list must come in prefix/URI pairs");
        }
        for (int i = 0; i < len; i += 2) {
            this.namespaceMap.put(namespaceArray[i], new NamespaceName(namespaceArray[i + 1]));
        }
    }

    public NamespaceName getNamespaceName(String prefix) {
        NamespaceName nsName = (NamespaceName)this.namespaceMap.get(prefix);
        return nsName == null ? NamespaceName.NULL_NAMESPACE : nsName;
    }

    public ExpandedQName getExpandedName(String qName) {
        int index = qName.indexOf(58);
        if (index <= 0) {
            return new ExpandedQName(NamespaceName.NULL_NAMESPACE, qName);
        }
        String prefix = qName.substring(0, index);
        String local = qName.substring(index + 1);
        return new ExpandedQName(this.getNamespaceName(prefix), local, prefix);
    }
}

