/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.parser;

import com.novell.util.URIResolver;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.sax.SAXtoDOM;
import com.novell.xml.util.XMLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Vector;
import org.w3c.dom.Document;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXParserImpl
implements XMLParser {
    private URL contextURI = null;
    private Vector errorList = new Vector(2, 2);
    private final eHandler errorHandler = new eHandler();
    private final Parser parser = SAXParserImpl.constructParser();
    private boolean fatalErrorDetected = false;
    private SAXtoDOM useConverter = null;

    public SAXParserImpl() {
        try {
            this.parser.setLocale(Locale.getDefault());
            this.parser.setErrorHandler(this.errorHandler);
        }
        catch (SAXException e) {
            this.errorList.addElement(e.getLocalizedMessage());
        }
    }

    public Document parse(InputStream input) {
        try {
            if (this.parser == null) {
                return null;
            }
            this.errorList.removeAllElements();
            this.fatalErrorDetected = false;
            InputSource inputSource = new InputSource(input);
            inputSource.setSystemId(this.contextURI != null ? this.contextURI.toString() : "");
            SAXtoDOM handler = this.useConverter != null ? this.useConverter : new SAXtoDOM(DocumentImpl.newDocument());
            this.parser.setDocumentHandler(handler);
            this.parser.setDTDHandler(handler);
            this.parser.parse(inputSource);
            if (!this.fatalErrorDetected) {
                return handler.getResult();
            }
        }
        catch (IOException e) {
            this.errorList.addElement(e.getLocalizedMessage());
        }
        catch (SAXException e) {
            this.errorList.addElement(e.getLocalizedMessage());
        }
        return null;
    }

    public Document parse(Reader input) {
        try {
            if (this.parser == null) {
                return null;
            }
            this.errorList.removeAllElements();
            this.fatalErrorDetected = false;
            InputSource inputSource = new InputSource(input);
            inputSource.setSystemId(this.contextURI != null ? this.contextURI.toString() : "");
            SAXtoDOM handler = this.useConverter != null ? this.useConverter : new SAXtoDOM(DocumentImpl.newDocument());
            this.parser.setDocumentHandler(handler);
            this.parser.setDTDHandler(handler);
            this.parser.parse(inputSource);
            if (!this.fatalErrorDetected) {
                return handler.getResult();
            }
        }
        catch (IOException e) {
            this.errorList.addElement(e.getLocalizedMessage());
        }
        catch (SAXException e) {
            this.errorList.addElement(e.getLocalizedMessage());
        }
        return null;
    }

    public Document parse(String uri) throws FileNotFoundException, IOException, MalformedURLException {
        this.setContextURI(uri);
        return this.parse(this.contextURI.openStream());
    }

    public Document parse(InputSource inputSource) throws FileNotFoundException, IOException {
        this.setContextURI(inputSource.getSystemId());
        if (inputSource.getByteStream() != null) {
            return this.parse(inputSource.getByteStream());
        }
        if (inputSource.getCharacterStream() != null) {
            return this.parse(inputSource.getCharacterStream());
        }
        return this.parse(inputSource.getSystemId());
    }

    public Document parse(File file) throws FileNotFoundException {
        try {
            this.setContextURI(file.getName());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return this.parse(new FileInputStream(file));
    }

    public void setConverter(SAXtoDOM converter) {
        this.useConverter = converter;
    }

    public void setContextURI(String uri) throws MalformedURLException {
        URL fileBase = XMLUtil.filenameToURL(".");
        String resolvedURI = URIResolver.resolveURI(uri, fileBase.toString());
        this.contextURI = new URL(resolvedURI);
    }

    public boolean anyErrors() {
        return !this.errorList.isEmpty();
    }

    public Vector getErrorMsgs() {
        return this.errorList;
    }

    public String getErrorMsgString() {
        if (this.anyErrors()) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < this.errorList.size(); ++i) {
                buffer.append((String)this.errorList.elementAt(i));
                if (i >= this.errorList.size() - 1) continue;
                buffer.append('\n');
            }
            return buffer.toString();
        }
        return "";
    }

    public void reportErrorMsgs(OutputStream out) {
        PrintWriter writer = new PrintWriter(out);
        for (int i = 0; i < this.errorList.size(); ++i) {
            String msg = (String)this.errorList.elementAt(i);
            writer.println(msg);
        }
        writer.flush();
    }

    private static Parser constructParser() {
        String parserName = System.getProperty("com.novell.xml.parser");
        if (parserName == null) {
            parserName = System.getProperty("org.xml.sax.parser");
        }
        if (parserName == null) {
            parserName = "com.jclark.xml.sax.CommentDriver";
        }
        try {
            Class<?> parserClass = Class.forName(parserName);
            return (Parser)parserClass.newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.toString());
        }
    }

    private class eHandler
    extends HandlerBase {
        private eHandler() {
        }

        public void error(SAXParseException e) {
        }

        public void fatalError(SAXParseException e) {
            StringBuffer msg = new StringBuffer();
            String systemId = e.getSystemId();
            if (systemId != null) {
                msg.append('\'');
                msg.append(systemId);
                msg.append("': ");
            }
            if (e.getLineNumber() != -1) {
                msg.append('(');
                msg.append(e.getLineNumber());
                msg.append("): ");
            }
            msg.append(e.getLocalizedMessage());
            SAXParserImpl.this.errorList.addElement(msg.toString());
            SAXParserImpl.this.fatalErrorDetected = true;
        }

        public void warning(SAXParseException e) {
        }
    }
}

