/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.sax;

import com.novell.io.EncodingStreamWriter;
import com.novell.xml.sax.DocumentCommentHandler;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.NamespaceStack;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.util.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.Stack;
import org.xml.sax.AttributeList;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class SAXWriter
implements XmlWriter,
DocumentCommentHandler {
    private Parser parser;
    private InputSource inputSource;
    private Locator locator = null;
    private Writer writer;
    private String encoding = null;
    private boolean indent = false;
    private boolean writeDeclaration = false;
    private boolean standalone = false;
    private String doctypePublic = null;
    private String doctypeSystem = null;
    private boolean disableTextEscaping = false;
    private Collection cdataSectionElements = null;
    protected int indentLevel;
    protected boolean firstElement;
    protected int lastNode;
    protected boolean startTagOpen;
    protected boolean children;
    private boolean cdataOutput;
    protected Stack stateStack = new Stack();
    protected NamespaceStack namespaceStack = new NamespaceStack();
    protected static final int XML_SPACE_DEFAULT = 0;
    protected static final int XML_SPACE_PRESERVE = 1;
    protected static final Integer xmlSpaceDefault = new Integer(0);
    protected static final Integer xmlSpacePreserve = new Integer(1);
    protected int xmlSpace = 0;

    public SAXWriter(Parser parser, InputSource inputSource, Writer writer) {
        this.parser = parser;
        this.inputSource = inputSource;
        this.writer = writer;
    }

    public SAXWriter(Parser parser, InputSource inputSource, OutputStream outputStream, String encoding) throws UnsupportedEncodingException {
        this.parser = parser;
        this.inputSource = inputSource;
        this.encoding = encoding;
        try {
            this.writer = new EncodingStreamWriter(outputStream, encoding);
        }
        catch (UnsupportedEncodingException e) {
            this.writer = new OutputStreamWriter(outputStream, encoding);
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void write() throws IOException {
        this.indentLevel = 0;
        try {
            this.parser.setDocumentHandler(this);
            this.parser.parse(this.inputSource);
            this.flush();
        }
        catch (SAXException e) {
            this.flush();
            throw new IOException(e.toString());
        }
    }

    public boolean getWriteDeclaration() {
        return this.writeDeclaration;
    }

    public void setWriteDeclaration(boolean writeDeclaration) {
        this.writeDeclaration = writeDeclaration;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean getIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public boolean getStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public String getDoctypePublic() {
        return this.doctypePublic;
    }

    public void setDoctypePublic(String doctypePublic) {
        this.doctypePublic = doctypePublic;
    }

    public String getDoctypeSystem() {
        return this.doctypeSystem;
    }

    public void setDoctypeSystem(String doctypeSystem) {
        this.doctypeSystem = doctypeSystem;
    }

    public boolean getDisableTextEscaping() {
        return this.disableTextEscaping;
    }

    public void setDisableTextEscaping(boolean disableTextEscaping) {
        this.disableTextEscaping = disableTextEscaping;
    }

    public Collection getCdataSectionElements() {
        return this.cdataSectionElements;
    }

    public void setCdataSectionElements(Collection cdataSectionElements) {
        this.cdataSectionElements = cdataSectionElements;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        try {
            this.indentLevel = 0;
            this.firstElement = true;
            this.lastNode = -1;
            this.startTagOpen = false;
            this.children = false;
            this.cdataOutput = false;
            if (this.writeDeclaration) {
                this.writeDeclaration();
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        try {
            if (this.firstElement && this.doctypeSystem != null && this.doctypeSystem.length() > 0) {
                this.writeDTD(name);
            }
            this.firstElement = false;
            this.children = true;
            this.pushState();
            this.closeStartTag();
            this.injectWhitespace(1);
            String xmlSpaceValue = atts.getValue("xml:space");
            if (xmlSpaceValue != null) {
                this.xmlSpace = xmlSpaceValue.equals("preserve") ? 1 : 0;
            }
            this.cdataOutput = this.useCdataOutput(name);
            this.children = false;
            this.lastNode = 1;
            ++this.indentLevel;
            this.startTagOpen = true;
            this.writer.write(60);
            this.writer.write(name);
            for (int i = 0; i < atts.getLength(); ++i) {
                String attName = atts.getName(i);
                this.writer.write(32);
                this.writer.write(attName);
                this.writer.write(61);
                String attValue = atts.getValue(i);
                XMLUtil.encodeAttribute(this.writer, attValue);
                if (!XMLUtil.isNamespaceDecl(attName)) continue;
                String prefix = XMLUtil.getPrefix(attName);
                String nsPrefix = prefix.length() > 0 ? XMLUtil.getLocalName(attName) : "";
                String resolvedURI = attValue;
                this.namespaceStack.add(nsPrefix, new NamespaceName(resolvedURI));
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String name) throws SAXException {
        try {
            if (!this.children) {
                this.closeStartTag();
            } else {
                if (this.indent && this.xmlSpace != 1 && this.lastNode != 3) {
                    this.writer.write(10);
                    for (int i = 0; i < this.indentLevel - 1; ++i) {
                        this.writer.write(9);
                    }
                }
                this.writer.write("</");
                this.writer.write(name);
                this.writer.write(62);
            }
            --this.indentLevel;
            this.popState();
            this.lastNode = 1;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.children = true;
            this.closeStartTag();
            String buffer = new String(ch, start, length);
            if (this.cdataOutput) {
                XMLUtil.encodeAsCData(this.writer, buffer);
            } else if (this.disableTextEscaping) {
                this.writer.write(buffer);
            } else {
                XMLUtil.encodeText(this.writer, buffer);
            }
            this.lastNode = 3;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            if (target == null || target.length() == 0) {
                this.comment(data);
            } else {
                this.children = true;
                this.closeStartTag();
                this.injectWhitespace(7);
                this.writer.write("<?");
                this.writer.write(target);
                if (data != null && data.length() > 0) {
                    this.writer.write(32);
                    this.writer.write(data);
                }
                this.writer.write("?>");
                this.lastNode = 7;
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void comment(String data) throws SAXException {
        try {
            this.children = true;
            this.closeStartTag();
            this.injectWhitespace(8);
            this.writer.write("<!--");
            this.writer.write(data);
            this.writer.write("-->");
            this.lastNode = 8;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    protected void writeDeclaration() throws IOException {
        this.writer.write("<?xml version=\"1.0\"");
        if (this.encoding != null && this.encoding.length() > 0) {
            this.writer.write(" encoding=\"");
            this.writer.write(this.encoding);
            this.writer.write(34);
        }
        if (this.standalone) {
            this.writer.write(" standalone=\"yes\"");
        }
        this.writer.write("?>");
    }

    protected void writeDTD(String name) throws IOException {
        if (name == null || name.length() == 0) {
            return;
        }
        this.injectWhitespace(1);
        this.writer.write("<!DOCTYPE ");
        this.writer.write(name);
        if (this.doctypePublic != null && this.doctypePublic.length() > 0) {
            this.writer.write(" PUBLIC ");
            int quote = this.doctypePublic.indexOf(34) >= 0 ? 39 : 34;
            this.writer.write(quote);
            this.writer.write(this.doctypePublic);
            this.writer.write(quote);
            this.writer.write(32);
            quote = this.doctypeSystem.indexOf(34) >= 0 ? 39 : 34;
            this.writer.write(quote);
            this.writer.write(this.doctypeSystem);
            this.writer.write(quote);
        } else {
            this.writer.write(" SYSTEM ");
            int quote = this.doctypeSystem.indexOf(34) >= 0 ? 39 : 34;
            this.writer.write(quote);
            this.writer.write(this.doctypeSystem);
            this.writer.write(quote);
        }
        this.writer.write(" >");
    }

    protected void injectWhitespace(int nodeType) throws IOException {
        if (!this.indent || this.xmlSpace == 1) {
            return;
        }
        switch (nodeType) {
            case 1: 
            case 7: 
            case 8: {
                if (this.lastNode == 3) break;
                this.writer.write(10);
                for (int i = 0; i < this.indentLevel; ++i) {
                    this.writer.write(9);
                }
                break;
            }
        }
    }

    protected void closeStartTag() throws IOException {
        if (this.startTagOpen) {
            this.startTagOpen = false;
            if (this.children) {
                this.writer.write(62);
            } else {
                this.writer.write("/>");
            }
        }
    }

    protected boolean useCdataOutput(String elementName) {
        String localPart;
        String prefix;
        if (this.cdataSectionElements == null || this.cdataSectionElements.isEmpty()) {
            return false;
        }
        int index = elementName.indexOf(58);
        if (index > 0) {
            prefix = elementName.substring(0, index);
            localPart = elementName.substring(index + 1, elementName.length());
        } else {
            prefix = "";
            localPart = elementName;
        }
        NamespaceName nsName = this.namespaceStack.getNamespaceName(prefix);
        if (nsName == null) {
            return false;
        }
        return this.cdataSectionElements.contains(new ExpandedQName(nsName, localPart, prefix));
    }

    protected void pushState() {
        this.stateStack.push(this.children ? Boolean.TRUE : Boolean.FALSE);
        this.stateStack.push(this.cdataOutput ? Boolean.TRUE : Boolean.FALSE);
        this.stateStack.push(this.xmlSpace == 0 ? xmlSpaceDefault : xmlSpacePreserve);
        this.namespaceStack.push();
    }

    protected void popState() {
        this.namespaceStack.pop();
        this.xmlSpace = (Integer)this.stateStack.pop();
        this.cdataOutput = (Boolean)this.stateStack.pop();
        this.children = (Boolean)this.stateStack.pop();
    }
}

