/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.sax;

import com.novell.xml.dom.AttrImpl;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.dom.DocumentTypeImpl;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.sax.DocumentCommentHandler;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.NamespaceStack;
import com.novell.xml.util.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXtoDOM
implements DocumentCommentHandler,
DTDHandler {
    protected Document document;
    protected Node currentNode;
    protected int currentNodePosition;
    protected boolean novellDOM;
    protected boolean level2DOM;
    protected Locator locator = null;
    protected NamespaceStack namespaceStack;

    public SAXtoDOM(Document document) {
        this.document = document;
        this.novellDOM = document instanceof DocumentImpl;
        if (this.novellDOM) {
            ((DocumentImpl)document).setCheckNames(false);
        }
        this.level2DOM = document.getImplementation().hasFeature("XML", "2.0");
        if (this.level2DOM) {
            this.namespaceStack = new NamespaceStack();
        }
    }

    public Document getResult() {
        return this.document;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        Node child = this.document.getFirstChild();
        while (child != null) {
            Node temp = child.getNextSibling();
            this.document.removeChild(child);
            child = temp;
        }
        this.currentNode = this.document;
        if (this.novellDOM) {
            this.currentNodePosition = 0;
            this.setLocatorInfo((NodeImpl)((Object)this.document));
        }
    }

    public void endDocument() throws SAXException {
        Node child = this.document.getFirstChild();
        while (child != null) {
            Node temp = child.getNextSibling();
            if (temp != null && child.getNodeType() == 3 && temp.getNodeType() == 3) {
                ((Text)child).appendData(((Text)temp).getData());
                this.document.removeChild(temp);
                continue;
            }
            child = temp;
        }
        if (this.novellDOM) {
            if (this.document.getDoctype() != null) {
                DocumentTypeImpl docType = (DocumentTypeImpl)this.document.getDoctype();
                Element docElement = this.document.getDocumentElement();
                if (docElement != null) {
                    docType.setName(docElement.getTagName());
                }
            }
            ((DocumentImpl)this.document).setOrderCurrent(true);
        }
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        Element element;
        if (this.level2DOM) {
            String prefix;
            NamespaceName nsName;
            this.namespaceStack.push();
            for (int i = 0; i < atts.getLength(); ++i) {
                String attName = atts.getName(i);
                if (!XMLUtil.isNamespaceDecl(attName)) continue;
                String prefix2 = XMLUtil.getPrefix(attName);
                String nsPrefix = prefix2.length() > 0 ? XMLUtil.getLocalName(attName) : "";
                this.namespaceStack.add(nsPrefix, new NamespaceName(atts.getValue(i)));
            }
            element = XMLUtil.isQName(name) ? ((nsName = this.namespaceStack.getNamespaceName(prefix = XMLUtil.getPrefix(name))) == null || nsName.equals(NamespaceName.NULL_NAMESPACE) ? (prefix.length() == 0 ? this.document.createElementNS(null, name) : this.document.createElement(name)) : this.document.createElementNS(nsName.getString(), name)) : this.document.createElement(name);
        } else {
            element = this.document.createElement(name);
        }
        this.currentNode.appendChild(element);
        if (this.novellDOM) {
            this.setLocatorInfo((NodeImpl)((Object)element));
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr attr;
            String attName = atts.getName(i);
            if (this.level2DOM) {
                if (XMLUtil.isQName(attName)) {
                    String prefix = XMLUtil.getPrefix(attName);
                    NamespaceName nsName = null;
                    if (XMLUtil.isNamespaceDecl(attName)) {
                        nsName = NamespaceName.XMLNS_NAMESPACE;
                    } else if (prefix.length() > 0) {
                        nsName = this.namespaceStack.getNamespaceName(prefix);
                    }
                    if (nsName == null || nsName.equals(NamespaceName.NULL_NAMESPACE)) {
                        if (prefix.length() == 0) {
                            attr = this.document.createAttributeNS(null, attName);
                            element.setAttributeNodeNS(attr);
                        } else {
                            attr = this.document.createAttribute(attName);
                            element.setAttributeNode(attr);
                        }
                    } else {
                        attr = this.document.createAttributeNS(nsName.getString(), attName);
                        element.setAttributeNodeNS(attr);
                    }
                } else {
                    attr = this.document.createAttribute(attName);
                    element.setAttributeNode(attr);
                }
            } else {
                attr = this.document.createAttribute(atts.getName(i));
                element.setAttributeNode(attr);
            }
            attr.setValue(atts.getValue(i));
            if (!this.novellDOM) continue;
            if (atts.getType(i).equals("ID")) {
                ((AttrImpl)attr).setIdType(true);
            }
            this.setLocatorInfo((NodeImpl)((Object)attr));
        }
        this.currentNode = element;
    }

    public void endElement(String name) throws SAXException {
        this.currentNode = this.currentNode.getParentNode();
        Node node = this.currentNode = this.currentNode == null ? this.document : this.currentNode;
        if (this.level2DOM) {
            this.namespaceStack.pop();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        Text text = this.document.createTextNode(new String(ch, start, length));
        Node sib = this.currentNode.getLastChild();
        if (sib != null && sib.getNodeType() == 3) {
            ((Text)sib).appendData(text.getData());
            return;
        }
        this.currentNode.appendChild(text);
        if (this.novellDOM) {
            this.setLocatorInfo((NodeImpl)((Object)text));
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (target == null || target.length() == 0) {
            this.comment(data);
        } else {
            ProcessingInstruction pi = this.document.createProcessingInstruction(target, data);
            this.currentNode.appendChild(pi);
            if (this.novellDOM) {
                this.setLocatorInfo((NodeImpl)((Object)pi));
            }
        }
    }

    public void comment(String data) throws SAXException {
        Comment comment = this.document.createComment(data);
        this.currentNode.appendChild(comment);
        if (this.novellDOM) {
            this.setLocatorInfo((NodeImpl)((Object)comment));
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.novellDOM) {
            DocumentType docType = this.ensureDocType();
            NamedNodeMap notations = docType.getNotations();
            Notation notation = ((DocumentImpl)this.document).createNotation(name, publicId, systemId);
            notations.setNamedItem(notation);
            this.setLocatorInfo((NodeImpl)((Object)notation));
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.novellDOM) {
            DocumentType docType = this.ensureDocType();
            NamedNodeMap entities = docType.getEntities();
            Entity entity = ((DocumentImpl)this.document).createEntity(name, publicId, systemId, notationName);
            entities.setNamedItem(entity);
            this.setLocatorInfo((NodeImpl)((Object)entity));
        }
    }

    protected DocumentType ensureDocType() {
        DocumentType docType = this.document.getDoctype();
        if (docType == null) {
            docType = this.document.getImplementation().createDocumentType("x", "x", "x");
            ((DocumentImpl)this.document).setDocumentType((DocumentTypeImpl)docType);
        }
        return docType;
    }

    protected void setLocatorInfo(NodeImpl node) {
        if (this.locator != null) {
            String baseURI;
            node.setColumnNumber(this.locator.getColumnNumber());
            node.setLineNumber(this.locator.getLineNumber());
            String systemId = this.locator.getSystemId();
            if (!(systemId == null || (baseURI = node.getBaseURI()) != null && baseURI.equals(systemId))) {
                if (((NodeImpl)((Object)this.document)).getBaseURI() == null && node.getParentNode() == this.document) {
                    ((NodeImpl)((Object)this.document)).setBaseURI(systemId);
                } else {
                    node.setBaseURI(systemId);
                }
            }
        }
        node.setDocumentOrder(this.currentNodePosition++);
    }
}

