/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.util;

import com.novell.util.StringCache;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.NamespaceName;
import java.util.TreeMap;
import org.w3c.dom.Node;

public class ExpandedQName
implements Comparable {
    public static final String UNKNOWN_NAMESPACE = NamespaceName.UNKNOWN_NAMESPACE.getString();
    public static final String WILDCARD_LOCALPART = "*";
    protected int local_part_number;
    protected NamespaceName namespace_name;
    protected int prefix_number = -1;
    int hash = 0;
    private static final int CACHE_INITIAL_SIZE = 8;
    private static final int LOCAL_CACHE_INITIAL_SIZE = 128;
    protected static StringCache prefixCache = new StringCache(new TreeMap(), 8);
    protected static StringCache localPartCache = new StringCache(new TreeMap(), 128);
    private static final int wildcard_part_number = localPartCache.getNumber("*");
    public static final ExpandedQName WILDCARD_QNAME = new ExpandedQName(NamespaceName.WILDCARD_NAMESPACE, "*");

    public ExpandedQName(ExpandedQName src) {
        this.namespace_name = src.namespace_name;
        this.local_part_number = src.local_part_number;
        this.prefix_number = src.prefix_number;
    }

    public ExpandedQName(String namespace_name, String local_part) {
        this.namespace_name = namespace_name == null ? NamespaceName.UNKNOWN_NAMESPACE : new NamespaceName(namespace_name);
        this.local_part_number = localPartCache.getNumber(local_part);
    }

    public ExpandedQName(NamespaceName namespace_name, String local_part) {
        this.namespace_name = namespace_name;
        this.local_part_number = localPartCache.getNumber(local_part);
    }

    public ExpandedQName(Node node) {
        String nsName;
        String prefix;
        String qName = node.getNodeName();
        int index = qName.indexOf(58);
        if (index > 0) {
            prefix = qName.substring(0, index);
            this.prefix_number = prefixCache.getNumber(prefix);
        } else {
            this.prefix_number = -1;
            prefix = null;
        }
        this.namespace_name = this.prefix_number <= 0 && node.getNodeType() == 2 ? NamespaceName.NULL_NAMESPACE : ((nsName = DOMUtil.getURIforNSPrefix(prefix, node)) == null ? (this.prefix_number > 0 ? NamespaceName.UNKNOWN_NAMESPACE : NamespaceName.NULL_NAMESPACE) : new NamespaceName(nsName));
        this.local_part_number = localPartCache.getNumber(index == -1 ? qName : qName.substring(index + 1, qName.length()));
    }

    public ExpandedQName(String qName, Node contextNode) {
        String prefix;
        int index = qName.indexOf(58);
        if (index > 0) {
            prefix = qName.substring(0, index);
            this.prefix_number = prefixCache.getNumber(prefix);
        } else {
            this.prefix_number = 0;
            prefix = "";
        }
        String nsName = DOMUtil.getURIforNSPrefix(prefix, contextNode);
        this.namespace_name = nsName == null ? NamespaceName.NULL_NAMESPACE : new NamespaceName(nsName);
        this.local_part_number = localPartCache.getNumber(index == -1 ? qName : qName.substring(index + 1, qName.length()));
    }

    public ExpandedQName(String prefix, String local_part, Node contextNode) {
        this.prefix_number = prefixCache.getNumber(prefix);
        String nsName = DOMUtil.getURIforNSPrefix(prefix, contextNode);
        this.namespace_name = nsName == null ? NamespaceName.NULL_NAMESPACE : new NamespaceName(nsName);
        this.local_part_number = localPartCache.getNumber(local_part);
    }

    public ExpandedQName(String namespace_name, String local_part, String prefix) {
        this.prefix_number = prefixCache.getNumber(prefix);
        this.namespace_name = namespace_name == null ? NamespaceName.UNKNOWN_NAMESPACE : new NamespaceName(namespace_name);
        this.local_part_number = localPartCache.getNumber(local_part);
    }

    public ExpandedQName(NamespaceName namespace_name, String local_part, String prefix) {
        this.prefix_number = prefixCache.getNumber(prefix);
        this.namespace_name = namespace_name;
        this.local_part_number = localPartCache.getNumber(local_part);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.namespace_name.hashCode() * this.local_part_number + this.local_part_number;
        }
        return this.hash;
    }

    public boolean equals(Object rhs) {
        return rhs instanceof ExpandedQName && this.equals((ExpandedQName)rhs);
    }

    public boolean equals(ExpandedQName rhs) {
        return this == rhs || (this.local_part_number == rhs.local_part_number || this.local_part_number == wildcard_part_number || rhs.local_part_number == wildcard_part_number) && this.namespace_name.equals(rhs.namespace_name);
    }

    public boolean namespaceNameEquals(ExpandedQName rhs) {
        return this.namespace_name.equals(rhs.namespace_name);
    }

    public boolean namespaceNameEquals(NamespaceName rhs) {
        return this.namespace_name.equals(rhs);
    }

    public boolean namespaceNameEquals(String rhs) {
        return rhs.equals(this.getNamespaceName());
    }

    public boolean localPartEquals(ExpandedQName rhs) {
        return this.local_part_number == rhs.local_part_number || this.local_part_number == wildcard_part_number || rhs.local_part_number == wildcard_part_number;
    }

    public boolean localPartEquals(String rhs) {
        return this.local_part_number == wildcard_part_number || this.getLocalPart().equals(rhs);
    }

    public int compareTo(Object rhs) {
        if (!(rhs instanceof ExpandedQName)) {
            return -1;
        }
        int ns = this.namespace_name.compareTo(((ExpandedQName)rhs).namespace_name);
        if (ns != 0) {
            return ns;
        }
        if (this.localPartEquals((ExpandedQName)rhs)) {
            return 0;
        }
        return this.getLocalPart().compareTo(((ExpandedQName)rhs).getLocalPart());
    }

    public String toString() {
        return this.namespace_name.getString() + this.getLocalPart();
    }

    public String getQName() {
        if (this.prefix_number != -1) {
            if (this.prefix_number == 0) {
                return this.getLocalPart();
            }
            return prefixCache.getString(this.prefix_number) + ":" + this.getLocalPart();
        }
        if (this.namespace_name.equals(NamespaceName.UNKNOWN_NAMESPACE)) {
            return "{Unknown}:" + this.getLocalPart();
        }
        return this.getLocalPart();
    }

    public NamespaceName getNamespaceName() {
        return this.namespace_name;
    }

    public String getNamespaceURI() {
        return this.namespace_name.getString();
    }

    public String getLocalPart() {
        return localPartCache.getString(this.local_part_number);
    }

    public String getPrefix() {
        return this.prefix_number == -1 ? null : prefixCache.getString(this.prefix_number);
    }
}

