/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.util;

import com.novell.util.StringCache;
import java.util.TreeMap;

public class NamespaceName
implements Comparable {
    public static final String WILDCARD_URI = "*";
    private int namespace_number;
    private static final int CACHE_INITIAL_SIZE = 8;
    private static StringCache uriCache = new StringCache(new TreeMap(), 8);
    private static final int wildcard_number = uriCache.getNumber("*");
    public static final NamespaceName XML_NAMESPACE = new NamespaceName("http://www.w3.org/XML/1998/namespace");
    public static final NamespaceName XMLNS_NAMESPACE = new NamespaceName("http://www.w3.org/2000/xmlns/");
    public static final NamespaceName NULL_NAMESPACE = new NamespaceName("");
    public static final NamespaceName WILDCARD_NAMESPACE = new NamespaceName(wildcard_number);
    public static final NamespaceName UNKNOWN_NAMESPACE = new NamespaceName("#{Unknown}#");

    public NamespaceName(String namespaceName) {
        this.namespace_number = namespaceName == null ? 0 : uriCache.getNumber(namespaceName);
    }

    private NamespaceName(int number) {
        this.namespace_number = number;
    }

    public String getString() {
        return uriCache.getString(this.namespace_number);
    }

    public boolean isEmpty() {
        return this.namespace_number == 0;
    }

    public int hashCode() {
        return this.namespace_number;
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof NamespaceName) {
            return this.equals((NamespaceName)rhs);
        }
        if (rhs instanceof String) {
            return uriCache.getString(this.namespace_number).equals(rhs) || this.namespace_number == wildcard_number;
        }
        return false;
    }

    public boolean equals(NamespaceName rhs) {
        return this == rhs || this.namespace_number == rhs.namespace_number || this.namespace_number == wildcard_number || rhs.namespace_number == wildcard_number;
    }

    public boolean equals(String rhs) {
        return uriCache.getString(this.namespace_number).equals(rhs);
    }

    public int compareTo(Object rhs) {
        if (rhs instanceof NamespaceName) {
            return this.namespace_number - ((NamespaceName)rhs).namespace_number;
        }
        if (rhs instanceof String) {
            return uriCache.getString(this.namespace_number).compareTo((String)rhs);
        }
        return -1;
    }
}

