/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.util;

import com.novell.io.CharEncodingException;
import com.novell.xml.util.BuiltInRef;
import com.novell.xml.util.XMLCharDefs;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;

public final class XMLUtil {
    public static final String XML_STYLE_SHEET = "xml-stylesheet";
    public static final String DIGITS = "0123456789";
    public static final String HEX_DIGITS = "0123456789abcdefABCDEF";
    private static final String AMP = "amp";
    private static final String APOS = "apos";
    private static final String QUOT = "quot";
    private static final String LT = "lt";
    private static final String GT = "gt";
    private static final String AMP_FULL = "&amp;";
    private static final String APOS_FULL = "&apos;";
    private static final String QUOT_FULL = "&quot;";
    private static final String LT_FULL = "&lt;";
    private static final String GT_FULL = "&gt;";
    private static final int BUILT_IN_REF_COUNT = 5;
    private static final BuiltInRef[] BUILT_IN_REFS = new BuiltInRef[]{new BuiltInRef("amp", '&'), new BuiltInRef("apos", '\''), new BuiltInRef("quot", '\"'), new BuiltInRef("lt", '<'), new BuiltInRef("gt", '>')};

    public static URL filenameToURL(String filename) throws MalformedURLException {
        File file = new File(filename);
        String path = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (file.isDirectory()) {
            path = path + "/";
        }
        return new URL("file", "", path);
    }

    public static String escape(String string) {
        return XMLUtil.escape(string, Integer.MAX_VALUE);
    }

    public static String escape(String string, int maxLength) {
        if (string == null) {
            return "(null)";
        }
        String s = XMLUtil.toXML(string);
        if (s.length() > maxLength) {
            s = s.substring(0, maxLength - 3) + "...";
        }
        return s;
    }

    public static String quote(String string) {
        return XMLUtil.quote(string, Integer.MAX_VALUE);
    }

    public static String quote(String string, int maxLength) {
        if (string == null) {
            return "(null)";
        }
        String s = XMLUtil.toXML(string, "\"");
        if (s.length() > maxLength - 2) {
            s = s.substring(0, maxLength - 5) + "...";
        }
        return "\"" + s + "\"";
    }

    public static String normalizeWhitespace(String source) {
        int i;
        StringBuffer result = new StringBuffer(source.length());
        for (i = 0; i < source.length() && XMLUtil.isXMLWhitespace(source.charAt(i)); ++i) {
        }
        boolean lastwhite = false;
        while (i < source.length()) {
            block4: {
                char c;
                block5: {
                    block3: {
                        c = source.charAt(i);
                        if (!XMLUtil.isXMLWhitespace(c)) break block3;
                        if (lastwhite) break block4;
                        c = ' ';
                        lastwhite = true;
                        break block5;
                    }
                    lastwhite = false;
                }
                result.append(c);
            }
            ++i;
        }
        if (lastwhite) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    public static boolean isXMLName(String str) {
        if (str.length() == 0) {
            return false;
        }
        char c = str.charAt(0);
        if (!XMLUtil.isXMLName(c)) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            if (XMLCharDefs.isXMLNameChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isXMLName(char c) {
        return XMLCharDefs.isXMLLetter(c) || c == '_' || c == ':';
    }

    public static boolean isXMLNameChar(char ch) {
        return XMLCharDefs.isXMLNameChar(ch);
    }

    public static boolean isNCName(char c) {
        return XMLCharDefs.isXMLLetter(c) || c == '_';
    }

    public static boolean isNCName(String str) {
        if (str.length() == 0) {
            return false;
        }
        char c = str.charAt(0);
        if (!XMLUtil.isNCName(c)) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            if (c != ':' && XMLCharDefs.isXMLNameChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNCNameChar(char ch) {
        return ch != ':' && XMLCharDefs.isXMLNameChar(ch);
    }

    public static boolean isQName(String name) {
        int index = name.indexOf(58);
        if (index != -1) {
            if (index == 0 || index == name.length() - 1) {
                return false;
            }
            return XMLUtil.isNCName(name.substring(0, index)) && XMLUtil.isNCName(name.substring(index + 1, name.length()));
        }
        return XMLUtil.isNCName(name);
    }

    public static boolean isPITarget(String name) {
        return XMLUtil.isXMLName(name) && !name.equalsIgnoreCase("xml");
    }

    public static boolean isXMLWhitespace(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (XMLUtil.isXMLWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isXMLWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static boolean isXMLVersionNum(String str) {
        if (str.length() < 1) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == ':' || c == '-') continue;
            return false;
        }
        return true;
    }

    public static boolean isXMLEncName(String str) {
        if (str.length() < 1) {
            return false;
        }
        char c = str.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            c = str.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == ':' || c == '-') continue;
            return false;
        }
        return true;
    }

    public static boolean isNamespaceDecl(String name) {
        return name.startsWith("xmlns") && (name.length() <= 5 || name.charAt(5) == ':');
    }

    public static String toXML(String rawString) {
        return XMLUtil.toXML(rawString, null);
    }

    public static String toXML(String rawString, String specials) {
        if (rawString.length() == 0) {
            return rawString;
        }
        StringBuffer buffer = new StringBuffer(rawString.length() * 2);
        for (int i = 0; i < rawString.length(); ++i) {
            char c = rawString.charAt(i);
            if (c == '&') {
                buffer.append(AMP_FULL);
                continue;
            }
            if (c == '<') {
                buffer.append(LT_FULL);
                continue;
            }
            if (c == '>') {
                buffer.append(GT_FULL);
                continue;
            }
            if (c == '\"') {
                buffer.append(QUOT_FULL);
                continue;
            }
            if (c == '\'') {
                buffer.append(APOS_FULL);
                continue;
            }
            if (specials != null && specials.indexOf(c) != -1) {
                buffer.append("&#x");
                buffer.append(Integer.toHexString(c));
                buffer.append(';');
                continue;
            }
            if (c >= '\ud800' && c <= '\udc00') {
                char trail = rawString.charAt(++i);
                int char4 = (c - 55296 << 10) + (trail - 56320) + 65536;
                buffer.append("&#x");
                buffer.append(Integer.toHexString(char4));
                buffer.append(';');
                continue;
            }
            if (c < ' ' && !XMLUtil.isXMLWhitespace(c)) {
                buffer.append("&#x");
                buffer.append(Integer.toHexString(63743 - c));
                buffer.append(';');
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static void encodeText(Writer stream, String text) throws IOException {
        int i = 0;
        int len = text.length();
        while (i < len) {
            try {
                char c = text.charAt(i);
                if (c == '&') {
                    stream.write(AMP_FULL);
                } else if (c == '<') {
                    stream.write(LT_FULL);
                } else if (c >= '\ud800' && c <= '\udc00') {
                    char trail = text.charAt(++i);
                    int char4 = (c - 55296 << 10) + (trail - 56320) + 65536;
                    stream.write("&#x");
                    stream.write(Integer.toHexString(char4));
                    stream.write(59);
                } else if (c < ' ' && !XMLUtil.isXMLWhitespace(c)) {
                    stream.write("&#x");
                    stream.write(Integer.toHexString(63743 - c));
                    stream.write(59);
                } else {
                    stream.write(c);
                    if (c == ']' && i + 2 < len && text.charAt(i + 1) == '[' && text.charAt(i + 2) == '>') {
                        i += 2;
                        stream.write(c);
                        stream.write(GT_FULL);
                    }
                }
                ++i;
            }
            catch (CharEncodingException e) {
                stream.write("&#x");
                int charValue = e.getValue();
                stream.write(Integer.toHexString(charValue));
                stream.write(59);
                i += charValue < 65535 ? 1 : 2;
            }
        }
    }

    private static void writeAlreadyEscaped(Writer stream, String text) throws IOException {
        int i = 0;
        int len = text.length();
        while (i < len) {
            try {
                char c = text.charAt(i);
                if (c >= '\ud800' && c <= '\udc00') {
                    char trail = text.charAt(++i);
                    int char4 = (c - 55296 << 10) + (trail - 56320) + 65536;
                    stream.write("&#x");
                    stream.write(Integer.toHexString(char4));
                    stream.write(59);
                } else if (c < ' ' && !XMLUtil.isXMLWhitespace(c)) {
                    stream.write("&#x");
                    stream.write(Integer.toHexString(63743 - c));
                    stream.write(59);
                } else {
                    stream.write(c);
                }
                ++i;
            }
            catch (CharEncodingException e) {
                stream.write("&#x");
                int charValue = e.getValue();
                stream.write(Integer.toHexString(charValue));
                stream.write(59);
                i += charValue < 65535 ? 1 : 2;
            }
        }
    }

    public static void encodeAttribute(Writer stream, String value) throws IOException {
        boolean hasTab;
        boolean hasDouble = value.indexOf(34) != -1;
        boolean hasSingle = value.indexOf(39) != -1;
        boolean hasNewLine = value.indexOf(10) != -1;
        boolean hasCarriageReturn = value.indexOf(13) != -1;
        boolean bl = hasTab = value.indexOf(9) != -1;
        if (hasDouble && hasSingle || hasNewLine || hasCarriageReturn || hasTab) {
            String encoded = XMLUtil.toXML(value, "\"\n\r\t");
            stream.write(34);
            XMLUtil.writeAlreadyEscaped(stream, encoded);
            stream.write(34);
        } else if (hasDouble) {
            stream.write(39);
            XMLUtil.encodeText(stream, value);
            stream.write(39);
        } else {
            stream.write(34);
            XMLUtil.encodeText(stream, value);
            stream.write(34);
        }
    }

    public static void encodeAsCData(Writer stream, String value) throws IOException {
        int i = 0;
        while (true) {
            try {
                stream.write("<![CDATA[");
                while (i < value.length()) {
                    char c = value.charAt(i);
                    if (c < ' ' && !XMLUtil.isXMLWhitespace(c)) {
                        throw new CharEncodingException(c, i, 0);
                    }
                    stream.write(c);
                    if (c == ']' && i + 2 < value.length() && value.charAt(i + 1) == ']' && value.charAt(i + 2) == '>') {
                        stream.write(value.charAt(++i));
                        stream.write("]]>");
                        stream.write("<![CDATA[");
                    }
                    ++i;
                }
                stream.write("]]>");
                return;
            }
            catch (CharEncodingException e) {
                stream.write("]]>");
                stream.write("&#x");
                int charValue = e.getValue();
                if (charValue < 32 && !XMLUtil.isXMLWhitespace((char)charValue)) {
                    charValue = 63743 - charValue;
                }
                stream.write(Integer.toHexString(charValue));
                stream.write(59);
                if ((i += charValue < 65535 ? 1 : 2) < value.length()) continue;
                return;
            }
            break;
        }
    }

    public static String replaceBuiltInEntities(String rawString) {
        StringBuffer buffer = new StringBuffer(64);
        int lastFound = 0;
        while (true) {
            int index;
            if ((index = rawString.indexOf(38, lastFound)) == -1) {
                buffer.append(rawString.substring(lastFound, rawString.length()));
                return buffer.toString();
            }
            if (rawString.charAt(++index) == '#') {
                int radix;
                String digits;
                if (rawString.charAt(++index) == 'x') {
                    digits = HEX_DIGITS;
                    radix = 16;
                } else {
                    digits = DIGITS;
                    radix = 10;
                }
                int start = ++index;
                while (digits.indexOf(rawString.charAt(index)) != -1) {
                    ++index;
                }
                buffer.append((char)Integer.valueOf(rawString.substring(start, index), radix).intValue());
            } else {
                int endIndex = rawString.indexOf(59, index);
                if (endIndex != -1) {
                    char c = '\u0000';
                    String ref = rawString.substring(index, endIndex);
                    for (int i = 0; i < 5; ++i) {
                        if (!XMLUtil.BUILT_IN_REFS[i].reference.equals(ref)) continue;
                        c = XMLUtil.BUILT_IN_REFS[i].value;
                        break;
                    }
                    if (c != '\u0000') {
                        buffer.append(c);
                    } else {
                        buffer.append('&');
                        buffer.append(rawString.substring(index, endIndex + 1));
                        index = endIndex;
                    }
                }
            }
            if (rawString.charAt(index) != ';') continue;
            ++index;
        }
    }

    public static String getPseudoAttribute(String data, String attrName) {
        try {
            int index;
            char c1 = attrName.charAt(0);
            int max = data.length();
            for (index = 0; index < max; ++index) {
                char scanChar = data.charAt(index);
                if (scanChar == c1) {
                    if (attrName.length() != 1 && !data.substring(index, index + attrName.length()).equals(attrName)) continue;
                    index += attrName.length();
                    break;
                }
                if (scanChar != '\"' && scanChar != '\'' || (index = data.indexOf(scanChar, index + 1)) != -1) continue;
                return "";
            }
            if (index >= max) {
                return "";
            }
            while (XMLUtil.isXMLWhitespace(data.charAt(index))) {
                ++index;
            }
            if (data.charAt(index) != '=') {
                return "";
            }
            ++index;
            while (XMLUtil.isXMLWhitespace(data.charAt(index))) {
                ++index;
            }
            char quote = data.charAt(index);
            if (quote != '\"' && quote != '\'') {
                return "";
            }
            int startIndex = ++index;
            while (data.charAt(index) != quote) {
                ++index;
            }
            String rawValue = data.substring(startIndex, index);
            return XMLUtil.replaceBuiltInEntities(rawValue);
        }
        catch (StringIndexOutOfBoundsException e) {
            return "";
        }
    }

    public static String getLocalName(String qname) {
        int index = qname.indexOf(58);
        if (index == -1) {
            return qname;
        }
        return qname.substring(index + 1);
    }

    public static String getPrefix(String qname) {
        int index = qname.indexOf(58);
        if (index == -1) {
            return "";
        }
        return qname.substring(0, index);
    }

    private XMLUtil() {
    }
}

