/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.XPathEvaluationException;
import org.w3c.dom.Node;

public class ArgumentList {
    private Expression[] expressions;

    public ArgumentList(Expression[] expressions) {
        this.expressions = expressions;
    }

    public ArgumentList() {
        this.expressions = null;
    }

    public String toString() {
        if (this.expressions != null) {
            String result = this.expressions[0].toString();
            for (int i = 1; i < this.expressions.length; ++i) {
                result = result + "," + this.expressions[i].toString();
            }
            return result;
        }
        return "";
    }

    ExpressionValue[] evaluate(Node contextNode, ExpressionContext context) throws XPathEvaluationException {
        ExpressionValue[] result = new ExpressionValue[this.expressions.length];
        for (int i = 0; i < this.expressions.length; ++i) {
            result[i] = this.expressions[i].evaluate(contextNode, context);
        }
        return result;
    }

    public int count() {
        return this.expressions != null ? this.expressions.length : 0;
    }

    public Expression getArgument(int index) {
        return this.expressions != null ? this.expressions[index] : null;
    }
}

