/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisElement;
import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.XPathUtil;
import org.w3c.dom.Node;

public class AxisChild
extends AxisElement {
    private Node child;

    public String toString() {
        return "child";
    }

    public void done() {
        super.done();
        this.child = null;
    }

    public Node first() {
        this.init();
        this.child = this.getContextNode();
        if (this.child.getNodeType() == 2) {
            this.child = null;
        }
        if (this.child != null) {
            this.child = this.child.getFirstChild();
            while (this.child != null && this.stripNode(this.child)) {
                this.child = XPathUtil.getNextSibling(this.child);
            }
        }
        return this.incPosition(this.child);
    }

    public Node next() {
        if (this.child != null) {
            this.child = XPathUtil.getNextSibling(this.child);
            while (this.child != null && this.stripNode(this.child)) {
                this.child = XPathUtil.getNextSibling(this.child);
            }
        }
        return this.incPosition(this.child);
    }

    public ContextListMark getMark() {
        return new Mark(this);
    }

    public Node returnToMark(ContextListMark mark) {
        ((Mark)mark).restoreState(this);
        return this.child;
    }

    protected class Mark
    extends Axis.AxisMark {
        private Node child;

        public Mark(AxisChild axis) {
            super(axis);
            this.child = axis.child;
        }

        public void restoreState(AxisChild axis) {
            super.restoreState(axis);
            axis.child = this.child;
        }
    }
}

