/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisDescendant;
import com.novell.xml.xpath.AxisElement;
import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.XPathUtil;
import org.w3c.dom.Node;

public class AxisFollowing
extends AxisElement {
    private Node sibling;
    private Node following;
    private AxisDescendant descendants = new AxisDescendant();

    public String toString() {
        return "following";
    }

    public void done() {
        super.done();
        this.sibling = null;
        this.following = null;
        this.descendants.done();
    }

    public Node first() {
        this.init();
        this.sibling = this.getContextNode();
        this.following = null;
        return this.next();
    }

    public Node next() {
        do {
            if (this.following != null) {
                if (this.following == this.sibling) {
                    this.descendants.setup(this.sibling, this.stripper);
                    this.following = this.descendants.first();
                } else {
                    this.following = this.descendants.next();
                }
            }
            while (this.following == null && this.sibling != null) {
                this.following = XPathUtil.getNextSibling(this.sibling);
                if (this.following == null) {
                    this.sibling = this.sibling.getParentNode();
                    continue;
                }
                this.sibling = this.following;
            }
        } while (this.following != null && this.stripNode(this.following));
        return this.incPosition(this.following);
    }

    public ContextListMark getMark() {
        return new Mark(this);
    }

    public Node returnToMark(ContextListMark mark) {
        ((Mark)mark).restoreState(this);
        return this.following;
    }

    protected class Mark
    extends Axis.AxisMark {
        private Node sibling;
        private Node following;
        private ContextListMark mark;

        public Mark(AxisFollowing axis) {
            super(axis);
            this.sibling = axis.sibling;
            this.following = axis.following;
            this.mark = axis.descendants.getMark();
        }

        public void restoreState(AxisFollowing axis) {
            super.restoreState(axis);
            axis.sibling = this.sibling;
            axis.following = this.following;
            axis.descendants.returnToMark(this.mark);
        }
    }
}

