/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.dom.ElementImpl;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.XPathNamespaceNode;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AxisNamespace
extends Axis {
    private Set foundPrefixes = new HashSet();
    private Node ancestor = null;
    private NamedNodeMap attrMap = null;
    private NamedNodeMap namespaceMap = null;
    private int mapIndex = -1;
    private int lastAttr = 0;
    private XPathNamespaceNode lastNamespace;
    private static final String XMLNS = "xmlns";

    public String toString() {
        return "namespace";
    }

    public void done() {
        super.done();
        this.foundPrefixes.clear();
        this.ancestor = null;
        this.attrMap = null;
        this.namespaceMap = null;
        this.lastNamespace = null;
    }

    public Node first() {
        this.init();
        this.mapIndex = -1;
        return this.next();
    }

    public Node next() {
        return this.incPosition(this.getNextNamespace());
    }

    public int principalNodeType() {
        return -1;
    }

    public ContextListMark getMark() {
        return new Mark(this);
    }

    public Node returnToMark(ContextListMark mark) {
        ((Mark)mark).restoreState(this);
        return this.lastNamespace;
    }

    protected void init() {
        super.init();
        Node node = this.getContextNode();
        this.namespaceMap = null;
        if (node != null && node.getNodeType() == 1) {
            this.ancestor = node;
            if (node instanceof ElementImpl) {
                this.namespaceMap = ((ElementImpl)node).getNamespaces();
            }
        } else {
            this.ancestor = null;
        }
        this.attrMap = null;
        this.lastAttr = -1;
        if (this.foundPrefixes != null) {
            this.foundPrefixes.clear();
        }
    }

    private Node getNextNamespace() {
        if (this.namespaceMap != null) {
            return this.namespaceMap.item(++this.mapIndex);
        }
        while (this.ancestor != null) {
            if (this.attrMap == null) {
                this.attrMap = this.ancestor.getAttributes();
                this.lastAttr = -1;
            }
            if (this.attrMap != null) {
                for (int i = this.lastAttr + 1; i < this.attrMap.getLength(); ++i) {
                    Attr attr = (Attr)this.attrMap.item(i);
                    String name = attr.getNodeName();
                    if (!XMLUtil.isNamespaceDecl(name)) continue;
                    String prefix = name.length() > XMLNS.length() ? name.substring(XMLNS.length() + 1, name.length()) : "";
                    String uri = attr.getNodeValue();
                    if (this.foundPrefixes.contains(prefix)) continue;
                    this.foundPrefixes.add(prefix);
                    this.lastAttr = i;
                    this.lastNamespace = new XPathNamespaceNode(prefix, uri, this.ancestor);
                    return this.lastNamespace;
                }
            }
            this.ancestor = this.ancestor.getParentNode();
            this.attrMap = null;
        }
        return null;
    }

    protected class Mark
    extends Axis.AxisMark {
        private Set foundPrefixes;
        private Node ancestor;
        private NamedNodeMap attrMap;
        private NamedNodeMap namespaceMap;
        private int mapIndex;
        private int lastAttr;
        private XPathNamespaceNode lastNamespace;

        public Mark(AxisNamespace axis) {
            super(axis);
            this.ancestor = axis.ancestor;
            this.lastAttr = axis.lastAttr;
            this.attrMap = this.ancestor == null ? null : this.ancestor.getAttributes();
            this.namespaceMap = axis.namespaceMap;
            this.mapIndex = axis.mapIndex;
            this.foundPrefixes = new HashSet(axis.foundPrefixes);
        }

        public void restoreState(AxisNamespace axis) {
            super.restoreState(axis);
            axis.ancestor = this.ancestor;
            axis.lastAttr = this.lastAttr;
            axis.mapIndex = this.mapIndex;
            axis.namespaceMap = this.namespaceMap;
            axis.attrMap = this.attrMap;
            axis.foundPrefixes = this.foundPrefixes;
            axis.lastNamespace = this.lastNamespace;
        }
    }
}

