/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisElement;
import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.XPathUtil;
import org.w3c.dom.Node;

public class AxisPreceding
extends AxisElement {
    private Node preceding;
    private Node ancestor;

    public String toString() {
        return "preceding";
    }

    public void done() {
        super.done();
        this.preceding = null;
        this.ancestor = null;
    }

    public Node first() {
        this.init();
        this.preceding = this.getContextNode();
        this.ancestor = this.preceding != null ? this.preceding.getParentNode() : null;
        return this.next();
    }

    public Node next() {
        do {
            if (this.preceding == null) continue;
            Node save = this.preceding;
            this.preceding = XPathUtil.getPreviousSibling(this.preceding);
            if (this.preceding != null) {
                save = this.preceding;
                this.preceding = this.getLastDescendant(this.preceding);
                if (this.preceding != null) continue;
                this.preceding = save;
                continue;
            }
            while (this.preceding == null && save != null) {
                save = this.preceding = save.getParentNode();
                if (this.preceding == null || this.preceding != this.ancestor) continue;
                this.ancestor = this.preceding.getParentNode();
                this.preceding = XPathUtil.getPreviousSibling(this.preceding);
            }
        } while (this.preceding != null && this.stripNode(this.preceding));
        return this.incPosition(this.preceding);
    }

    public int order() {
        return 2;
    }

    private Node getLastDescendant(Node node) {
        Node child;
        if (node == null) {
            return null;
        }
        node = child = node.getLastChild();
        while (child != null) {
            node = child;
            child = child.getLastChild();
        }
        if (node != null && XPathUtil.getNodeType(node) == 3) {
            while (node.getPreviousSibling() != null && XPathUtil.getNodeType(node.getPreviousSibling()) == 3) {
                node = node.getPreviousSibling();
            }
        }
        return node;
    }

    public ContextListMark getMark() {
        return new Mark(this);
    }

    public Node returnToMark(ContextListMark mark) {
        ((Mark)mark).restoreState(this);
        return this.preceding;
    }

    protected class Mark
    extends Axis.AxisMark {
        private Node preceding;
        private Node ancestor;

        public Mark(AxisPreceding axis) {
            super(axis);
            this.preceding = axis.preceding;
            this.ancestor = axis.ancestor;
        }

        public void restoreState(AxisPreceding axis) {
            super.restoreState(axis);
            axis.preceding = this.preceding;
            axis.ancestor = this.ancestor;
        }
    }
}

