/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisElement;
import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.XPathUtil;
import org.w3c.dom.Node;

public class AxisPrecedingSibling
extends AxisElement {
    private Node sibling;

    public String toString() {
        return "preceding-sibling";
    }

    public void done() {
        super.done();
        this.sibling = null;
    }

    public Node first() {
        this.init();
        this.sibling = this.getContextNode();
        short nodeType = this.sibling.getNodeType();
        if (this.sibling == null || nodeType == 2 || nodeType == -1) {
            this.sibling = null;
        } else {
            do {
                this.sibling = XPathUtil.getPreviousSibling(this.sibling);
            } while (this.sibling != null && this.stripNode(this.sibling));
        }
        return this.incPosition(this.sibling);
    }

    public Node next() {
        if (this.sibling != null) {
            do {
                this.sibling = XPathUtil.getPreviousSibling(this.sibling);
            } while (this.sibling != null && this.stripNode(this.sibling));
        }
        return this.incPosition(this.sibling);
    }

    public int order() {
        return 2;
    }

    public ContextListMark getMark() {
        return new Mark(this);
    }

    public Node returnToMark(ContextListMark mark) {
        ((Mark)mark).restoreState(this);
        return this.sibling;
    }

    protected class Mark
    extends Axis.AxisMark {
        private Node sibling;

        public Mark(AxisPrecedingSibling axis) {
            super(axis);
            this.sibling = axis.sibling;
        }

        public void restoreState(AxisPrecedingSibling axis) {
            super.restoreState(axis);
            axis.sibling = this.sibling;
        }
    }
}

