/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.BooleanExpr;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathUtil;
import org.w3c.dom.Node;

public abstract class ComparisonExpr
extends BooleanExpr
implements Expression {
    protected ComparisonExpr(Expression lhs, Expression rhs) {
        super(lhs, rhs);
    }

    protected boolean compareOperands(ExpressionValue lhs, ExpressionValue rhs, int compare) throws XPathEvaluationException {
        boolean result = false;
        int lhsType = lhs.getValueType();
        int rhsType = rhs.getValueType();
        if (lhsType == 3 || rhsType == 3) {
            if (rhsType == 3 && lhsType != 3) {
                int temp = lhsType;
                lhsType = rhsType;
                rhsType = temp;
                ExpressionValue temp2 = lhs;
                lhs = rhs;
                rhs = temp2;
                compare = -compare;
            }
            switch (rhsType) {
                case 0: {
                    result = this.compareBooleans(lhs.getBooleanValue(), rhs.getBooleanValue(), compare);
                    break;
                }
                case 1: {
                    result = this.compareNodeSetAndNumber(lhs.getNodeSetValue(), rhs.getNumberValue(), compare);
                    break;
                }
                case 2: {
                    result = this.compareNodeSetAndString(lhs.getNodeSetValue(), rhs.getStringValue(), compare);
                    break;
                }
                case 3: {
                    result = this.compareNodeSets(lhs.getNodeSetValue(), rhs.getNodeSetValue(), compare);
                    break;
                }
                default: {
                    result = this.compareNodeSetAndString(lhs.getNodeSetValue(), rhs.getStringValue(), compare);
                    break;
                }
            }
        } else {
            result = lhsType == 0 || rhsType == 0 ? this.compareBooleans(lhs.getBooleanValue(), rhs.getBooleanValue(), compare) : (lhsType == 1 || rhsType == 1 ? this.compareNumbers(lhs.getNumberValue(), rhs.getNumberValue(), compare) : (compare != 0 && compare != 3 && compare != -3 ? this.compareNumbers(lhs.getNumberValue(), rhs.getNumberValue(), compare) : this.compareStrings(lhs.getStringValue(), rhs.getStringValue(), compare)));
        }
        return result;
    }

    protected boolean compareNodeSets(NodeSet lhs, NodeSet rhs, int compare) {
        if (lhs.isEmpty() || rhs.isEmpty()) {
            return false;
        }
        Node lhsNode = lhs.first();
        while (lhsNode != null) {
            String lhsString = XPathUtil.getNodeValue(lhsNode);
            Node rhsNode = rhs.first();
            while (rhsNode != null) {
                if (this.compareStrings(lhsString, XPathUtil.getNodeValue(rhsNode), compare)) {
                    return true;
                }
                rhsNode = rhs.next();
            }
            lhsNode = lhs.next();
        }
        return false;
    }

    protected boolean compareNodeSetAndString(NodeSet lhs, String rhs, int compare) {
        if (lhs.isEmpty()) {
            return false;
        }
        Node node = lhs.first();
        while (node != null) {
            if (this.compareStrings(XPathUtil.getNodeValue(node), rhs, compare)) {
                return true;
            }
            node = lhs.next();
        }
        return false;
    }

    protected boolean compareNodeSetAndNumber(NodeSet lhs, double rhs, int compare) {
        if (lhs.isEmpty()) {
            return false;
        }
        Node node = lhs.first();
        while (node != null) {
            double nodeNumber = Double.valueOf(XPathUtil.getNodeValue(node));
            if (this.compareNumbers(nodeNumber, rhs, compare)) {
                return true;
            }
            node = lhs.next();
        }
        return false;
    }

    protected boolean compareBooleans(boolean lhs, boolean rhs, int compare) {
        boolean rhsInt;
        boolean lhsInt = lhs;
        boolean bl = rhsInt = rhs;
        if (compare == -3 || compare == 3) {
            return lhsInt != rhsInt;
        }
        if (compare == -2) {
            return lhsInt < rhsInt;
        }
        if (compare == -1) {
            return lhsInt <= rhsInt;
        }
        if (compare == 0) {
            return lhsInt == rhsInt;
        }
        if (compare == 1) {
            return lhsInt >= rhsInt;
        }
        if (compare == 2) {
            return lhsInt > rhsInt;
        }
        return false;
    }

    protected boolean compareNumbers(double lhs, double rhs, int compare) {
        if (compare == -3 || compare == 3) {
            return lhs != rhs;
        }
        if (compare == -2) {
            return lhs < rhs;
        }
        if (compare == -1) {
            return lhs <= rhs;
        }
        if (compare == 0) {
            return lhs == rhs;
        }
        if (compare == 1) {
            return lhs >= rhs;
        }
        if (compare == 2) {
            return lhs > rhs;
        }
        return false;
    }

    protected boolean compareStrings(String lhs, String rhs, int compare) {
        int result = lhs.compareTo(rhs);
        if (compare == -3 || compare == 3) {
            return result != 0;
        }
        if (result < 0) {
            return compare < 0;
        }
        if (result > 0) {
            return compare > 0;
        }
        if (result == 0) {
            return compare >= -1 && compare <= 1;
        }
        return false;
    }
}

