/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NamespaceContext;
import com.novell.xml.xpath.WhitespaceStripper;
import com.novell.xml.xpath.XPathEvaluationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Node;

public class ExpressionContext
implements NamespaceContext,
ContextNodeList,
WhitespaceStripper {
    private ContextNodeList contextNodeList;
    private Node namespaceContext;
    private Stack stack = new Stack();
    private Node currentNode;
    private Map properties = null;

    public ExpressionContext() {
    }

    public ExpressionContext(Map properties) {
        this.properties = properties;
    }

    public ExpressionContext(ExpressionContext iVal) {
        this.namespaceContext = iVal.namespaceContext;
        this.contextNodeList = iVal.contextNodeList;
        this.properties = iVal.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionValue evaluate(Node currentNode, Expression expression) throws XPathEvaluationException {
        ExpressionValue result;
        this.currentNode = currentNode;
        try {
            result = expression.evaluate(currentNode, this);
        }
        finally {
            this.currentNode = null;
        }
        return result;
    }

    public void pushState() {
        this.stack.push(new State(this));
    }

    public void popState() {
        ((State)this.stack.pop()).restoreState(this);
    }

    public void setContextNodeList(ContextNodeList list) {
        this.contextNodeList = list;
    }

    public void setNamespaceContext(Node node) {
        this.namespaceContext = node;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public NamespaceName getNamespaceName(String prefix) {
        Node nsContext = this.getNamespaceContext();
        if (prefix == null || prefix.length() <= 0 || nsContext == null) {
            return NamespaceName.NULL_NAMESPACE;
        }
        String uri = DOMUtil.getURIforNSPrefix(prefix, nsContext);
        if (uri == null) {
            return NamespaceName.NULL_NAMESPACE;
        }
        return new NamespaceName(uri);
    }

    public ExpandedQName getExpandedName(String qName) {
        return new ExpandedQName(qName, this.getNamespaceContext());
    }

    public Node first() throws XPathEvaluationException {
        return this.contextNodeList == null ? null : this.contextNodeList.first();
    }

    public Node next() throws XPathEvaluationException {
        return this.contextNodeList == null ? null : this.contextNodeList.next();
    }

    public int count() throws XPathEvaluationException {
        return this.contextNodeList == null ? 0 : this.contextNodeList.count();
    }

    public int position() {
        return this.contextNodeList == null ? 0 : this.contextNodeList.position();
    }

    public int order() {
        return this.contextNodeList == null ? 1 : this.contextNodeList.order();
    }

    public ContextListMark getMark() {
        return this.contextNodeList == null ? null : this.contextNodeList.getMark();
    }

    public Node returnToMark(ContextListMark mark) {
        if (this.contextNodeList != null) {
            return this.contextNodeList.returnToMark(mark);
        }
        return null;
    }

    public boolean stripNode(Node node) {
        return false;
    }

    public Node getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
    }

    public void removeProperty(String name, Object value) {
        this.properties.remove(name);
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    protected class State {
        private ContextNodeList contextNodeList;
        private Node namespaceContext;

        public State(ExpressionContext context) {
            this.contextNodeList = context.contextNodeList;
            this.namespaceContext = context.namespaceContext;
        }

        public void restoreState(ExpressionContext context) {
            context.contextNodeList = this.contextNodeList;
            context.namespaceContext = this.namespaceContext;
        }
    }
}

