/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.ArgumentList;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.XPathConversionException;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.XPathResetRegistrar;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class Function {
    private FunctionSignature signature;
    private Method[] methods = null;

    protected Function(FunctionSignature signature) {
        this.signature = signature;
    }

    public Function getInstance(ArgumentList args) throws XPathParserException {
        return this;
    }

    public ExpressionValue invoke(Object[] args) throws XPathEvaluationException {
        String errorMessage;
        if (this.methods == null) {
            this.findMethods();
        }
        int method = args.length - this.signature.getRequiredArgs().length;
        try {
            return (ExpressionValue)this.methods[method].invoke((Object)this, args);
        }
        catch (ClassCastException e) {
            throw new XPathConversionException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            errorMessage = e.getMessage();
        }
        catch (IllegalAccessException e) {
            errorMessage = e.getMessage();
        }
        String[] parms = new String[]{this.getSignature().getName().getQName(), errorMessage};
        throw new XPathEvaluationException("ee2", parms);
    }

    public boolean isConstant() {
        return false;
    }

    public void registerForReset(XPathResetRegistrar registrar) {
    }

    protected FunctionSignature getSignature() {
        return this.signature;
    }

    private void findMethods() throws XPathEvaluationException {
        try {
            Class<?> thisClass = this.getClass();
            int methodCount = 1 + this.signature.getOptionalArgs().length;
            this.methods = new Method[methodCount];
            Class[] req = this.signature.getRequiredArgs();
            this.methods[0] = thisClass.getMethod(this.signature.getName().getLocalPart(), req);
            Class[] opt = this.signature.getOptionalArgs();
            for (int i = 1; i < methodCount; ++i) {
                Class[] parms = new Class[req.length + i];
                for (int j = 0; j < req.length; ++j) {
                    parms[j] = req[j];
                }
                for (int k = 0; k <= i - 1; ++k) {
                    parms[j++] = opt[k];
                }
                this.methods[i] = thisClass.getMethod(this.signature.getName().getLocalPart(), parms);
            }
        }
        catch (NoSuchMethodException e) {
            throw new XPathEvaluationException("pe12", this.signature.getName().toString());
        }
    }
}

