/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.ArgumentList;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xml.xpath.XPathUtil;
import java.io.PrintWriter;
import java.math.BigDecimal;
import org.w3c.dom.Node;

public class FunctionCall
implements Expression {
    private ExpressionValue[] nullArgs = new ExpressionValue[0];
    private Function function;
    private ArgumentList args;
    private int[] argType;
    private Object[] argFrame;
    private DoubleCaster[] argCaster;
    boolean passContext = false;
    private static final Class interfaceExpressionValue = XPathUtil.doGetClass("com.novell.xml.xpath.ExpressionValue");
    private static final Class classString = XPathUtil.doGetClass("java.lang.String");
    private static final Class classNumber = XPathUtil.doGetClass("java.lang.Number");
    private static final Class classBigDecimal = XPathUtil.doGetClass("java.math.BigDecimal");
    private static final Class classBigInteger = XPathUtil.doGetClass("java.math.BigInteger");
    private static final Class classDouble = XPathUtil.doGetClass("java.lang.Double");
    private static final Class classFloat = XPathUtil.doGetClass("java.lang.Float");
    private static final Class classLong = XPathUtil.doGetClass("java.lang.Long");
    private static final Class classInteger = XPathUtil.doGetClass("java.lang.Integer");
    private static final Class classShort = XPathUtil.doGetClass("java.lang.Short");
    private static final Class classByte = XPathUtil.doGetClass("java.lang.Byte");
    private static final Class classBoolean = XPathUtil.doGetClass("java.lang.Boolean");
    private static final int TYPE_CORRECT = 0;
    private static final int TYPE_EXPRESSION_VALUE = 1;
    private static final int TYPE_BOOLEAN = 2;
    private static final int TYPE_NUMBER = 3;
    private static final int TYPE_STRING = 4;
    private static final int TYPE_NATIVE = 5;

    public FunctionCall(Function function) throws XPathParserException {
        this.args = new ArgumentList();
        this.function = function.getInstance(this.args);
        this.argFrame = null;
        this.argCaster = null;
        this.argType = null;
    }

    public FunctionCall(Function function, ArgumentList argList) throws XPathParserException {
        this.args = argList == null ? new ArgumentList() : argList;
        this.function = function.getInstance(this.args);
        this.setupArgs();
    }

    public Function getFunction() {
        return this.function;
    }

    public String toString() {
        return this.function.toString() + "(" + this.args.toString() + ")";
    }

    public ExpressionValue evaluate(Node contextNode, ExpressionContext context) throws XPathEvaluationException {
        ExpressionValue[] argList = this.args.count() > 0 ? this.args.evaluate(contextNode, context) : this.nullArgs;
        this.frameArguments(argList, contextNode, context);
        return this.function.invoke(this.argFrame);
    }

    public boolean isConstant() {
        return this.function.isConstant();
    }

    public Class getResultType() {
        return this.function.getSignature().getReturnType();
    }

    public void registerForReset(XPathResetRegistrar registrar) {
        this.function.registerForReset(registrar);
    }

    public void dump(PrintWriter writer, int indent) {
        XPathUtil.dump(this, writer, indent);
    }

    protected void frameArguments(ExpressionValue[] args, Node contextNode, ExpressionContext context) throws XPathEvaluationException {
        int arg0 = 0;
        if (this.passContext) {
            this.argFrame[0] = contextNode;
            this.argFrame[1] = context;
            arg0 = 2;
        }
        for (int i = 0; i < args.length; ++i) {
            if (this.argType[i] == 0) {
                this.argFrame[i + arg0] = args[i];
                continue;
            }
            if (this.argType[i] == 1) {
                ((ExpressionValue)this.argFrame[i + arg0]).castFrom(args[i]);
                continue;
            }
            if (this.argType[i] == 2) {
                this.argFrame[i + arg0] = new Boolean(args[i].getBooleanValue());
                continue;
            }
            if (this.argType[i] == 3) {
                this.argFrame[i + arg0] = this.argCaster[i + arg0].cast(args[i].getNumberValue());
                continue;
            }
            if (this.argType[i] == 4) {
                this.argFrame[i + arg0] = args[i].getStringValue();
                continue;
            }
            if (this.argType[i] != 5) continue;
            this.argFrame[i + arg0] = args[i].getNativeValue();
        }
    }

    protected void setupArgs() throws XPathParserException {
        int i = 0;
        try {
            FunctionSignature signature = this.function.getSignature();
            Class[] requiredArgs = signature.getRequiredArgs();
            Class[] optionalArgs = signature.getOptionalArgs();
            Class[] contextArgs = signature.getContextArgTypes();
            int arg0 = 0;
            if (requiredArgs.length >= 2 && requiredArgs[0] == contextArgs[0] && requiredArgs[1] == contextArgs[1]) {
                arg0 = 2;
                this.passContext = true;
            }
            this.argFrame = new Object[this.args.count() + (this.passContext ? 2 : 0)];
            this.argCaster = new DoubleCaster[this.argFrame.length];
            this.argType = new int[this.argFrame.length];
            if (this.passContext) {
                this.argType[0] = 0;
                this.argType[1] = 0;
            }
            for (i = arg0; i < requiredArgs.length && i - arg0 < this.args.count(); ++i) {
                if (!requiredArgs[i].isAssignableFrom(this.args.getArgument(i - arg0).getResultType())) {
                    FunctionCall.argConversion(this.argFrame, this.argCaster, this.argType, i, requiredArgs, i);
                    continue;
                }
                this.argType[i] = 0;
            }
            if (i < requiredArgs.length) {
                throw new XPathParserException("pe9");
            }
            if (i - arg0 < this.args.count() && optionalArgs.length != 0) {
                for (int j = 0; j < optionalArgs.length && i - arg0 < this.args.count(); ++j) {
                    if (!optionalArgs[j].isAssignableFrom(this.args.getArgument(i - arg0).getResultType())) {
                        FunctionCall.argConversion(this.argFrame, this.argCaster, this.argType, i, optionalArgs, j);
                    } else {
                        this.argType[i] = 0;
                    }
                    ++i;
                }
            }
            if (i - arg0 < this.args.count()) {
                throw new XPathParserException("pe10");
            }
            return;
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        String[] parms = new String[]{Integer.toString(i + 1), this.function.getSignature().getName().getQName()};
        throw new XPathParserException("pe11", parms);
    }

    private static void argConversion(Object[] frame, DoubleCaster[] casters, int[] flags, int i, Class[] argTypes, int j) throws InstantiationException, IllegalAccessException, IllegalArgumentException {
        if (Boolean.TYPE.isAssignableFrom(argTypes[j]) || classBoolean.isAssignableFrom(argTypes[j])) {
            flags[i] = 2;
        } else if (argTypes[j].isPrimitive() || classNumber.isAssignableFrom(argTypes[j])) {
            flags[i] = 3;
            casters[i] = new NumberCaster(argTypes[j]);
        } else if (classString.isAssignableFrom(argTypes[j])) {
            flags[i] = 4;
        } else if (interfaceExpressionValue.isAssignableFrom(argTypes[j])) {
            frame[i] = argTypes[j].newInstance();
            flags[i] = 1;
        } else {
            flags[i] = 5;
        }
    }

    protected static class NumberCaster
    implements DoubleCaster {
        protected DoubleCaster caster;

        public NumberCaster(Class formalType) throws IllegalArgumentException {
            if (formalType.isAssignableFrom(Double.TYPE) || formalType.isAssignableFrom(classDouble)) {
                this.caster = new toDouble();
            } else if (formalType.isAssignableFrom(Float.TYPE) || formalType.isAssignableFrom(classFloat)) {
                this.caster = new toFloat();
            } else if (formalType.isAssignableFrom(Long.TYPE) || formalType.isAssignableFrom(classLong)) {
                this.caster = new toLong();
            } else if (formalType.isAssignableFrom(Integer.TYPE) || formalType.isAssignableFrom(classInteger)) {
                this.caster = new toInteger();
            } else if (formalType.isAssignableFrom(Short.TYPE) || formalType.isAssignableFrom(classShort)) {
                this.caster = new toShort();
            } else if (formalType.isAssignableFrom(Byte.TYPE) || formalType.isAssignableFrom(classByte)) {
                this.caster = new toByte();
            } else if (formalType.isAssignableFrom(classBigDecimal)) {
                this.caster = new toBigDecimal();
            } else if (formalType.isAssignableFrom(classBigInteger)) {
                this.caster = new toBigInteger();
            } else {
                throw new IllegalArgumentException();
            }
        }

        public Number cast(double value) {
            return this.caster.cast(value);
        }

        private static class toBigInteger
        implements DoubleCaster {
            private toBigInteger() {
            }

            public Number cast(double value) {
                return new BigDecimal(value).toBigInteger();
            }
        }

        private static class toBigDecimal
        implements DoubleCaster {
            private toBigDecimal() {
            }

            public Number cast(double value) {
                return new BigDecimal(value);
            }
        }

        private static class toByte
        implements DoubleCaster {
            private toByte() {
            }

            public Number cast(double value) {
                return new Byte((byte)value);
            }
        }

        private static class toShort
        implements DoubleCaster {
            private toShort() {
            }

            public Number cast(double value) {
                return new Short((short)value);
            }
        }

        private static class toInteger
        implements DoubleCaster {
            private toInteger() {
            }

            public Number cast(double value) {
                return new Integer((int)value);
            }
        }

        private static class toLong
        implements DoubleCaster {
            private toLong() {
            }

            public Number cast(double value) {
                return new Long((long)value);
            }
        }

        private static class toFloat
        implements DoubleCaster {
            private toFloat() {
            }

            public Number cast(double value) {
                return new Float((float)value);
            }
        }

        private static class toDouble
        implements DoubleCaster {
            private toDouble() {
            }

            public Number cast(double value) {
                return new Double(value);
            }
        }
    }

    protected static interface DoubleCaster {
        public Number cast(double var1);
    }
}

