/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.util.ExpandedQName;

public class FunctionSignature {
    private ExpandedQName name;
    private Class returnType;
    private Class[] requiredArguments;
    private Class[] optionalArguments;
    private static Class[] contextArgs = null;

    public FunctionSignature(ExpandedQName name, Class returnType) {
        this.name = name;
        this.returnType = returnType;
        this.requiredArguments = new Class[0];
        this.optionalArguments = new Class[0];
    }

    public FunctionSignature(ExpandedQName name, Class returnType, Class[] arguments) {
        this.name = name;
        this.returnType = returnType;
        this.requiredArguments = arguments;
        this.optionalArguments = new Class[0];
    }

    public FunctionSignature(ExpandedQName name, Class returnType, Class[] requiredArguments, Class[] optionalArguments) {
        this.name = name;
        this.returnType = returnType;
        this.requiredArguments = requiredArguments;
        this.optionalArguments = optionalArguments;
    }

    public ExpandedQName getName() {
        return this.name;
    }

    public Class[] getRequiredArgs() {
        return this.requiredArguments;
    }

    public Class[] getOptionalArgs() {
        return this.optionalArguments;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public static Class[] getContextArgTypes() {
        try {
            if (contextArgs == null) {
                contextArgs = new Class[2];
                FunctionSignature.contextArgs[0] = Class.forName("org.w3c.dom.Node");
                FunctionSignature.contextArgs[1] = Class.forName("com.novell.xml.xpath.ExpressionContext");
            }
            return contextArgs;
        }
        catch (ClassNotFoundException e) {
            throw new Error(e.getLocalizedMessage());
        }
    }
}

