/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathConversionException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class InsertionOrderNodeSet
extends NodeSet {
    public InsertionOrderNodeSet() {
        this.set = new LinkedHashSet();
    }

    public InsertionOrderNodeSet(Collection copy) throws Exception {
        this.set = new LinkedHashSet();
        if (!copy.isEmpty()) {
            Iterator it = copy.iterator();
            if (it.hasNext() && !(it.next() instanceof Node)) {
                throw new Exception("Cannot convert arbitrary type to node-set");
            }
            this.set = new LinkedHashSet();
            this.set.addAll(copy);
        }
    }

    public InsertionOrderNodeSet(NodeSet copy) {
        this.set = new LinkedHashSet();
        Node node = copy.first();
        while (node != null) {
            this.set.add(node);
            node = copy.next();
        }
    }

    public void union(NodeSet rhs) {
        Node node = rhs.first();
        while (node != null) {
            this.set.add(node);
            node = rhs.next();
        }
    }

    public void castFrom(Object type) throws XPathConversionException {
        if (type == null) {
            this.set = new LinkedHashSet();
        } else if (type instanceof ExpressionValue) {
            NodeSet nodeSet = ((ExpressionValue)type).getNodeSetValue();
            this.set = new LinkedHashSet();
            Node node = nodeSet.first();
            while (node != null) {
                this.set.add(node);
                node = nodeSet.next();
            }
        } else if (type instanceof DocumentFragment) {
            this.set = new LinkedHashSet();
            this.add((DocumentFragment)type);
        } else if (type instanceof Node) {
            this.set = new LinkedHashSet();
            this.set.add((Node)type);
        } else {
            throw new XPathConversionException("vce1");
        }
    }

    public int order() {
        return 3;
    }
}

