/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.dom.DocumentFragmentImpl;
import com.novell.xml.dom.DocumentOrderComparator;
import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.XPathConversionException;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xml.xpath.XPathUtil;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class NodeSet
implements ExpressionValue,
Expression,
ContextNodeList {
    protected Set set;
    private Iterator setIt;
    private int index;
    private Node currentNode;
    protected static Class argType = XPathUtil.doGetClass("com.novell.xml.xpath.NodeSet");
    protected static DocumentOrderComparator nodeComparator = new DocumentOrderComparator();

    public NodeSet() {
        this.set = new TreeSet(nodeComparator);
    }

    public NodeSet(Collection copy) throws Exception {
        if (copy.isEmpty()) {
            this.set = new TreeSet(nodeComparator);
        } else {
            Iterator it = copy.iterator();
            if (it.hasNext() && !(it.next() instanceof Node)) {
                throw new Exception("Cannot convert arbitrary type to node-set");
            }
            this.set = new TreeSet(nodeComparator);
            this.set.addAll(copy);
        }
    }

    public NodeSet(NodeSet copy) {
        this.set = new TreeSet(nodeComparator);
        this.set.addAll(copy.set);
    }

    public static Class getArgType() {
        return argType;
    }

    public void add(Node node) {
        this.set.add(node);
    }

    public void add(DocumentFragment fragment) {
        if (fragment instanceof DocumentFragmentImpl) {
            ((DocumentFragmentImpl)fragment).updateDocumentOrder();
        }
        for (Node node = fragment.getFirstChild(); node != null; node = node.getNextSibling()) {
            this.set.add(node);
        }
    }

    public void remove(Node node) {
        this.set.remove(node);
    }

    public boolean contains(Node node) {
        return this.set.contains(node);
    }

    public void union(NodeSet rhs) {
        this.set.addAll(rhs.set);
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public String toString() {
        return this.getStringValue();
    }

    public ExpressionValue evaluate(Node contextNode, ExpressionContext context) {
        return this;
    }

    public boolean isConstant() {
        return true;
    }

    public Class getResultType() {
        return NodeSet.getArgType();
    }

    public void registerForReset(XPathResetRegistrar registrar) {
    }

    public void dump(PrintWriter writer, int indent) {
        XPathUtil.dump(this, writer, indent);
    }

    public int getValueType() {
        return 3;
    }

    public void castFrom(Object type) throws XPathConversionException {
        if (type == null) {
            this.set = new TreeSet(nodeComparator);
        } else if (type instanceof ExpressionValue) {
            this.set = new TreeSet(nodeComparator);
            this.set.addAll(((ExpressionValue)type).getNodeSetValue().set);
        } else if (type instanceof DocumentFragment) {
            this.set = new TreeSet(nodeComparator);
            this.add((DocumentFragment)type);
        } else if (type instanceof Node) {
            this.set = new TreeSet(nodeComparator);
            this.set.add((Node)type);
        } else {
            throw new XPathConversionException("vce1");
        }
    }

    public boolean getBooleanValue() throws XPathConversionException {
        return !this.set.isEmpty();
    }

    public double getNumberValue() throws XPathConversionException {
        return NumberValue.convertToNumber(this.getStringValue());
    }

    public String getStringValue() {
        if (this.set.isEmpty()) {
            return "";
        }
        if (this.set instanceof SortedSet) {
            return XPathUtil.getNodeValue((Node)((SortedSet)this.set).first());
        }
        return XPathUtil.getNodeValue((Node)this.set.iterator().next());
    }

    public NodeSet getNodeSetValue() throws XPathConversionException {
        return this;
    }

    public Object getNativeValue() {
        if (this.set.isEmpty()) {
            return null;
        }
        if (this.set instanceof SortedSet) {
            return ((SortedSet)this.set).first();
        }
        return this.set.iterator().next();
    }

    public void dump(PrintWriter writer) {
        writer.println("Node set:");
        Node node = this.first();
        if (node != null) {
            do {
                writer.println("\t" + XPathUtil.describeNode(node));
            } while ((node = this.next()) != null);
        } else {
            writer.println("\tEmpty");
        }
    }

    public Node first() {
        this.currentNode = null;
        this.setIt = this.set.iterator();
        this.index = 0;
        if (this.setIt.hasNext()) {
            ++this.index;
            this.currentNode = (Node)this.setIt.next();
        }
        return this.currentNode;
    }

    public Node next() {
        this.currentNode = null;
        if (this.setIt != null && this.setIt.hasNext()) {
            ++this.index;
            this.currentNode = (Node)this.setIt.next();
        }
        return this.currentNode;
    }

    public int count() {
        return this.set.size();
    }

    public int position() {
        return this.index;
    }

    public int order() {
        return 1;
    }

    public ContextListMark getMark() {
        return new Mark(this);
    }

    public Node returnToMark(ContextListMark mark) {
        ((Mark)mark).restoreState(this);
        return this.currentNode;
    }

    protected class Mark
    implements ContextListMark {
        private Iterator setIt;
        private int index;
        private Node currentNode;

        Mark(NodeSet set) {
            this.index = set.index;
            this.setIt = set.setIt;
            this.currentNode = set.currentNode;
        }

        void restoreState(NodeSet set) {
            set.index = this.index;
            set.setIt = this.setIt;
            set.currentNode = this.currentNode;
        }
    }
}

