/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.NodeTest;
import com.novell.xml.xpath.NodeTypeToken;
import org.w3c.dom.Node;

public class NodeType
implements NodeTest {
    private int type;

    public NodeType(NodeTypeToken token) {
        this.type = token.getNodeType();
    }

    public int getNodeType() {
        return this.type;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "comment()";
            }
            case 2: {
                return "node()";
            }
            case 3: {
                return "processing-instruction()";
            }
            case 4: {
                return "text()";
            }
        }
        return "<unknown-node-type>";
    }

    protected NodeType(int type) {
        this.type = type;
    }

    public boolean evaluate(Node node) {
        switch (this.type) {
            case 1: {
                return node.getNodeType() == 8;
            }
            case 2: {
                return true;
            }
            case 3: {
                return node.getNodeType() == 7;
            }
            case 4: {
                short nodeType = node.getNodeType();
                return nodeType == 3 || nodeType == 4;
            }
        }
        return false;
    }
}

