/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Binder;
import com.novell.xml.xpath.Token;

public class NodeTypeToken
extends Token {
    public static final int NOT_NODE_TYPE = 0;
    public static final int COMMENT = 1;
    public static final int NODE = 2;
    public static final int PI = 3;
    public static final int TEXT = 4;
    private int nodeType;
    private static final Binder[] BINDER = new Binder[]{new Binder(1, "comment"), new Binder(2, "node"), new Binder(3, "processing-instruction"), new Binder(4, "text")};

    public NodeTypeToken(int t) {
        super(12);
        this.nodeType = t;
    }

    public boolean equals(Token rhs) {
        return super.equals(rhs) && this.getNodeType() == ((NodeTypeToken)rhs).getNodeType();
    }

    public String toString() {
        return super.toString() + "{" + NodeTypeToken.getTypeName(this.getNodeType()) + "}";
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public static String getTypeName(int type) {
        if (type < 1 || type > 4) {
            return "";
        }
        return NodeTypeToken.BINDER[type - 1].text;
    }

    public static int getTypeFromName(String name) {
        for (int i = 0; i < 4; ++i) {
            if (!name.equals(NodeTypeToken.BINDER[i].text)) continue;
            return NodeTypeToken.BINDER[i].id;
        }
        return 0;
    }
}

