/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.Scanner;
import com.novell.xml.xpath.XPathConversionException;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xml.xpath.XPathUtil;
import java.io.PrintWriter;
import java.math.BigDecimal;
import org.w3c.dom.Node;

public class NumberValue
implements ExpressionValue,
Expression,
Comparable {
    private double value;
    private static final Class argType = XPathUtil.doGetClass("com.novell.xml.xpath.NumberValue");

    public NumberValue(double v) {
        this.value = v;
    }

    public NumberValue() {
        this.value = Double.NaN;
    }

    public static Class getArgType() {
        return argType;
    }

    public String toString() {
        return this.getStringValue();
    }

    public static double convertToNumber(String string) {
        String stripped = string.trim();
        if (stripped.length() < 1) {
            return Double.NaN;
        }
        boolean sign = false;
        if (stripped.charAt(0) == '-') {
            stripped = stripped.substring(1, stripped.length());
            sign = true;
        }
        double result = Scanner.scanNumber(stripped);
        if (sign && !Double.isNaN(result)) {
            result = -result;
        }
        return result;
    }

    public ExpressionValue evaluate(Node contextNode, ExpressionContext context) {
        return this;
    }

    public boolean isConstant() {
        return true;
    }

    public Class getResultType() {
        return NumberValue.getArgType();
    }

    public void registerForReset(XPathResetRegistrar registrar) {
    }

    public void dump(PrintWriter writer, int indent) {
        XPathUtil.dump(this, writer, indent);
    }

    public int getValueType() {
        return 1;
    }

    public void castFrom(Object type) throws XPathConversionException {
        this.value = type instanceof ExpressionValue ? ((ExpressionValue)type).getNumberValue() : (type instanceof Number ? ((Number)type).doubleValue() : NumberValue.convertToNumber(type.toString()));
    }

    public boolean getBooleanValue() throws XPathConversionException {
        return this.value != 0.0 && this.value != -0.0 && !Double.isNaN(this.value);
    }

    public double getNumberValue() throws XPathConversionException {
        return this.value;
    }

    public String getStringValue() {
        return NumberValue.getStringValue(this.value);
    }

    public static String getStringValue(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return Double.toString(value);
        }
        if (Math.floor(value) == value) {
            return new BigDecimal(value).toBigInteger().toString();
        }
        if (0.001 <= value && value < 1.0E7 || -0.001 >= value && value > -1.0E7) {
            return Double.toString(value);
        }
        boolean negative = value < 0.0;
        String eNotation = Double.toString(negative ? -value : value);
        int e = eNotation.indexOf(69);
        if (e == -1) {
            return negative ? "-" + eNotation : eNotation;
        }
        int exp = Integer.valueOf(eNotation.substring(e + 1, eNotation.length()));
        String mantissa = eNotation.substring(0, e);
        int len = exp < 0 ? Math.abs(exp) - 1 + mantissa.length() : Math.max(exp - 1, mantissa.length());
        StringBuffer sb = new StringBuffer(len);
        if (negative) {
            sb.append('-');
        }
        if (exp < 0) {
            sb.append('0');
            sb.append('.');
            for (int i = 0; i < Math.abs(exp) - 1; ++i) {
                sb.append('0');
            }
            sb.append(mantissa.charAt(0));
            if (mantissa.length() > 3 || mantissa.charAt(2) != '0') {
                sb.append(mantissa.substring(2, mantissa.length()));
            }
        } else {
            sb.append(mantissa.charAt(0));
            sb.append(mantissa.substring(2, 2 + exp));
            sb.append('.');
            sb.append(mantissa.substring(2 + exp, mantissa.length()));
        }
        return sb.toString();
    }

    public NodeSet getNodeSetValue() throws XPathConversionException {
        throw new XPathConversionException("vce1");
    }

    public Object getNativeValue() {
        return new Double(this.value);
    }

    public void dump(PrintWriter writer) {
        writer.println(this.getStringValue());
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object other) {
        if (other instanceof NumberValue) {
            return Double.doubleToLongBits(((NumberValue)other).value) == Double.doubleToLongBits(this.value);
        }
        if (other instanceof Double) {
            return Double.doubleToLongBits((Double)other) == Double.doubleToLongBits(this.value);
        }
        return false;
    }

    public int compareTo(Object other) {
        if (other instanceof NumberValue) {
            return Double.compare(this.value, ((NumberValue)other).value);
        }
        return Double.compare(this.value, (Double)other);
    }
}

