/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Binder;
import com.novell.xml.xpath.Token;

public class OperatorToken
extends Token {
    public static final int NOT_AN_OPERATOR = 0;
    public static final int NOT_EQUALS = 1;
    public static final int MUL = 2;
    public static final int PLUS = 3;
    public static final int MINUS = 4;
    public static final int SLASH = 5;
    public static final int SLASH_SLASH = 6;
    public static final int LESS_THAN = 7;
    public static final int LESS_THAN_EQUALS = 8;
    public static final int EQUALS = 9;
    public static final int GREATER_THAN = 10;
    public static final int GREATER_THAN_EQUALS = 11;
    public static final int AND = 12;
    public static final int DIV = 13;
    public static final int MOD = 14;
    public static final int OR = 15;
    public static final int PIPE = 16;
    private static final int OPERATOR_COUNT = 16;
    private static final Binder[] BINDER = new Binder[]{new Binder(1, "!="), new Binder(2, "*"), new Binder(3, "+"), new Binder(4, "-"), new Binder(5, "/"), new Binder(6, "//"), new Binder(7, "<"), new Binder(8, "<="), new Binder(9, "="), new Binder(10, ">"), new Binder(11, ">="), new Binder(12, "and"), new Binder(13, "div"), new Binder(14, "mod"), new Binder(15, "or"), new Binder(16, "|")};
    private int operator;

    public OperatorToken(int opType) {
        super(10);
        this.operator = opType;
        if (opType <= 0 || opType > 16) {
            throw new Error("OperatorToken: invalid opType in constructor");
        }
    }

    public boolean equals(Token rhs) {
        return super.equals(rhs) && this.getOperator() == ((OperatorToken)rhs).getOperator();
    }

    public String toString() {
        return super.toString() + "{" + OperatorToken.BINDER[this.getOperator() - 1].text + "}";
    }

    public int getOperator() {
        return this.operator;
    }

    public static int getOpType(String opString) {
        char firstChar = opString.charAt(0);
        for (int i = 0; i < 16; ++i) {
            char checkChar = OperatorToken.BINDER[i].text.charAt(0);
            if (firstChar < checkChar) {
                return 0;
            }
            if (firstChar != checkChar || !opString.equals(OperatorToken.BINDER[i].text)) continue;
            return OperatorToken.BINDER[i].id;
        }
        return 0;
    }
}

