/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.AbsoluteLocationPath;
import com.novell.xml.xpath.AndExpr;
import com.novell.xml.xpath.ArgumentList;
import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisAttribute;
import com.novell.xml.xpath.AxisChild;
import com.novell.xml.xpath.AxisDescendantOrSelf;
import com.novell.xml.xpath.AxisNameToken;
import com.novell.xml.xpath.AxisParent;
import com.novell.xml.xpath.AxisSelf;
import com.novell.xml.xpath.Basis;
import com.novell.xml.xpath.BrokenNotEqualsExpr;
import com.novell.xml.xpath.DivExpr;
import com.novell.xml.xpath.EqualsExpr;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.FilterExpr;
import com.novell.xml.xpath.FunctionCall;
import com.novell.xml.xpath.FunctionLibrary;
import com.novell.xml.xpath.FunctionLibraryImpl;
import com.novell.xml.xpath.FunctionNameToken;
import com.novell.xml.xpath.GreaterThanEqualsExpr;
import com.novell.xml.xpath.GreaterThanExpr;
import com.novell.xml.xpath.LessThanEqualsExpr;
import com.novell.xml.xpath.LessThanExpr;
import com.novell.xml.xpath.LiteralToken;
import com.novell.xml.xpath.MinusExpr;
import com.novell.xml.xpath.ModExpr;
import com.novell.xml.xpath.MulExpr;
import com.novell.xml.xpath.NamespaceContext;
import com.novell.xml.xpath.NodeTest;
import com.novell.xml.xpath.NodeType;
import com.novell.xml.xpath.NodeTypePI;
import com.novell.xml.xpath.NodeTypeToken;
import com.novell.xml.xpath.NotEqualsExpr;
import com.novell.xml.xpath.NumberToken;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.OperatorToken;
import com.novell.xml.xpath.OrExpr;
import com.novell.xml.xpath.PathExpr;
import com.novell.xml.xpath.PlusExpr;
import com.novell.xml.xpath.Predicate;
import com.novell.xml.xpath.RelativeLocationPath;
import com.novell.xml.xpath.Scanner;
import com.novell.xml.xpath.Step;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.Token;
import com.novell.xml.xpath.UnaryExpr;
import com.novell.xml.xpath.UnionExpr;
import com.novell.xml.xpath.VariableBindings;
import com.novell.xml.xpath.VariableRefToken;
import com.novell.xml.xpath.VariableReference;
import com.novell.xml.xpath.WildcardName;
import com.novell.xml.xpath.WildcardNameToken;
import com.novell.xml.xpath.XPathException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.functions.XPathBuiltIns;
import java.util.Vector;

public class Parser {
    private Token[] tokens;
    private int currentToken;
    private Token nullToken = new Token(0);
    private VariableBindings variables;
    private FunctionLibrary library;
    private NamespaceContext namespaces;
    private boolean brokenMode = false;
    private static FunctionLibrary defaultFunctionLibrary = null;
    private static Object libSync = new Object();

    public Parser(NamespaceContext namespaces) {
        this(null, Parser.getDefaultFunctionLibrary(), namespaces);
    }

    public Parser(VariableBindings variables, FunctionLibrary library, NamespaceContext namespaces) {
        this.variables = variables;
        this.library = library != null ? library : Parser.getDefaultFunctionLibrary();
        this.namespaces = namespaces;
    }

    public boolean setBrokenMode(boolean doBroken) {
        boolean oldMode = this.brokenMode;
        this.brokenMode = doBroken;
        return oldMode;
    }

    public Expression parse(String source) throws XPathParserException {
        this.tokenize(source);
        return this.parse();
    }

    public Expression parse(Token[] tokens) throws XPathParserException {
        this.tokens = tokens;
        this.currentToken = 0;
        return this.parse();
    }

    protected Expression parse() throws XPathParserException {
        Expression expr = this.parseExpr();
        if (this.peekToken().getType() != 0) {
            throw new XPathParserException("pe5");
        }
        return expr;
    }

    protected Expression parseExpr() throws XPathParserException {
        if (this.peekToken().getType() == 0) {
            throw new XPathParserException("pe6");
        }
        return this.parseOrExpr();
    }

    protected Expression parseOrExpr() throws XPathParserException {
        Expression expr = this.parseAndExpr();
        Token token = this.peekToken();
        while (this.getOperator(token) == 15) {
            this.nextToken();
            expr = new OrExpr(expr, this.parseAndExpr());
            token = this.peekToken();
        }
        return expr;
    }

    protected Expression parseAndExpr() throws XPathParserException {
        Expression expr = this.parseEqualityExpr();
        Token token = this.peekToken();
        while (token.getType() == 10 && ((OperatorToken)token).getOperator() == 12) {
            this.nextToken();
            expr = new AndExpr(expr, this.parseEqualityExpr());
            token = this.peekToken();
        }
        return expr;
    }

    protected Expression parseEqualityExpr() throws XPathParserException {
        Expression expr = this.parseRelationalExpr();
        Token token = this.peekToken();
        while (true) {
            int opr = this.getOperator(token);
            switch (opr) {
                case 9: {
                    this.nextToken();
                    expr = new EqualsExpr(expr, this.parseRelationalExpr());
                    break;
                }
                case 1: {
                    this.nextToken();
                    if (this.brokenMode) {
                        expr = new BrokenNotEqualsExpr(expr, this.parseRelationalExpr());
                        break;
                    }
                    expr = new NotEqualsExpr(expr, this.parseRelationalExpr());
                    break;
                }
                default: {
                    return expr;
                }
            }
            token = this.peekToken();
        }
    }

    protected Expression parseRelationalExpr() throws XPathParserException {
        Expression expr = this.parseAdditiveExpr();
        Token token = this.peekToken();
        while (true) {
            int opr = this.getOperator(token);
            switch (opr) {
                case 7: {
                    this.nextToken();
                    expr = new LessThanExpr(expr, this.parseAdditiveExpr());
                    break;
                }
                case 10: {
                    this.nextToken();
                    expr = new GreaterThanExpr(expr, this.parseAdditiveExpr());
                    break;
                }
                case 8: {
                    this.nextToken();
                    expr = new LessThanEqualsExpr(expr, this.parseAdditiveExpr());
                    break;
                }
                case 11: {
                    this.nextToken();
                    expr = new GreaterThanEqualsExpr(expr, this.parseAdditiveExpr());
                    break;
                }
                default: {
                    return expr;
                }
            }
            token = this.peekToken();
        }
    }

    protected Expression parseAdditiveExpr() throws XPathParserException {
        Expression expr = this.parseMultiplicativeExpr();
        Token token = this.peekToken();
        while (true) {
            int opr = this.getOperator(token);
            switch (opr) {
                case 3: {
                    this.nextToken();
                    expr = new PlusExpr(expr, this.parseMultiplicativeExpr());
                    break;
                }
                case 4: {
                    this.nextToken();
                    expr = new MinusExpr(expr, this.parseMultiplicativeExpr());
                    break;
                }
                default: {
                    return expr;
                }
            }
            token = this.peekToken();
        }
    }

    protected Expression parseMultiplicativeExpr() throws XPathParserException {
        Expression expr = this.parseUnaryExpr();
        Token token = this.peekToken();
        while (true) {
            int opr = this.getOperator(token);
            switch (opr) {
                case 2: {
                    this.nextToken();
                    expr = new MulExpr(expr, this.parseUnaryExpr());
                    break;
                }
                case 13: {
                    this.nextToken();
                    expr = new DivExpr(expr, this.parseUnaryExpr());
                    break;
                }
                case 14: {
                    this.nextToken();
                    expr = new ModExpr(expr, this.parseUnaryExpr());
                    break;
                }
                default: {
                    return expr;
                }
            }
            token = this.peekToken();
        }
    }

    protected Expression parseUnaryExpr() throws XPathParserException {
        Token token = this.peekToken();
        int opr = this.getOperator(token);
        if (opr == 4) {
            this.nextToken();
            return new UnaryExpr(this.parseUnaryExpr());
        }
        return this.parseUnionExpr();
    }

    protected Expression parseUnionExpr() throws XPathParserException {
        Expression expr = this.parsePathExpr();
        Token token = this.peekToken();
        int opr;
        while ((opr = this.getOperator(token)) == 16) {
            this.nextToken();
            expr = new UnionExpr(expr, this.parsePathExpr());
            token = this.peekToken();
        }
        return expr;
    }

    protected Expression parsePathExpr() throws XPathParserException {
        Token token = this.peekToken();
        int opr = this.getOperator(token);
        int tokenType = token.getType();
        if (opr == 5 || tokenType == 14 || tokenType == 11 || tokenType == 12 || opr == 6 || tokenType == 5 || tokenType == 6 || tokenType == 7) {
            return this.parseLocationPath();
        }
        Expression expr = this.parseFilterExpr();
        token = this.peekToken();
        while (true) {
            opr = this.getOperator(token);
            switch (opr) {
                case 5: {
                    this.nextToken();
                    expr = new PathExpr(expr, this.parseRelativeLocationPath());
                    break;
                }
                case 6: {
                    this.nextToken();
                    NodeTypeToken ntt = new NodeTypeToken(2);
                    RelativeLocationPath compExpr = new RelativeLocationPath(new Step(new Basis(new AxisDescendantOrSelf(), (NodeTest)new NodeType(ntt))));
                    compExpr = new RelativeLocationPath(compExpr, this.parseRelativeLocationPath());
                    expr = new PathExpr(expr, compExpr);
                    break;
                }
                default: {
                    return expr;
                }
            }
            token = this.peekToken();
        }
    }

    protected Expression parseFilterExpr() throws XPathParserException {
        Expression expr = this.parsePrimaryExpr();
        Token token = this.peekToken();
        while (token.getType() == 3) {
            this.nextToken();
            expr = new FilterExpr(expr, this.parsePredicate());
            token = this.peekToken();
        }
        return expr;
    }

    protected Expression parsePrimaryExpr() throws XPathParserException {
        Token token = this.peekToken();
        switch (token.getType()) {
            case 17: {
                Expression variable;
                this.nextToken();
                VariableRefToken vrt = (VariableRefToken)token;
                ExpandedQName name = new ExpandedQName(this.namespaces.getNamespaceName(vrt.getPrefix()), vrt.getLocalPart(), vrt.getPrefix());
                Expression expression = variable = this.variables != null ? this.variables.getVariable(name) : null;
                if (variable == null) {
                    throw new XPathParserException("pe14", name.getQName());
                }
                return new VariableReference(name, variable);
            }
            case 15: {
                this.nextToken();
                return new StringValue(((LiteralToken)token).getValue());
            }
            case 16: {
                this.nextToken();
                return new NumberValue(((NumberToken)token).getValue());
            }
            case 13: {
                return this.parseFunctionCall();
            }
            case 1: {
                this.nextToken();
                Expression expr = this.parseExpr();
                if (this.peekToken().getType() != 2) {
                    throw new XPathParserException("pe4", ')');
                }
                this.nextToken();
                return expr;
            }
        }
        throw new XPathParserException("pe7");
    }

    protected Expression parseFunctionCall() throws XPathParserException {
        Token token = this.peekToken();
        this.nextToken();
        FunctionNameToken fnt = (FunctionNameToken)token;
        ExpandedQName name = new ExpandedQName(this.namespaces.getNamespaceName(fnt.getPrefix()), fnt.getLocalPart(), fnt.getPrefix());
        return new FunctionCall(this.library.getFunction(name), this.parseArgumentList());
    }

    protected ArgumentList parseArgumentList() throws XPathParserException {
        int tokenType;
        Token token = this.peekToken();
        if (token.getType() != 1) {
            throw new XPathParserException("pe4", '(');
        }
        this.nextToken();
        token = this.peekToken();
        if (token.getType() == 2) {
            this.nextToken();
            return null;
        }
        Vector<Expression> argList = new Vector<Expression>(2, 2);
        do {
            argList.addElement(this.parseExpr());
            token = this.peekToken();
            tokenType = token.getType();
            if (tokenType == 8) {
                this.nextToken();
                continue;
            }
            if (tokenType == 2) continue;
            throw new XPathParserException("pe4", ')');
        } while (tokenType == 8);
        this.nextToken();
        Expression[] args = new Expression[argList.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = (Expression)argList.elementAt(i);
        }
        return new ArgumentList(args);
    }

    protected Expression parseLocationPath() throws XPathParserException {
        Token token = this.peekToken();
        int opr = this.getOperator(token);
        if (opr == 5) {
            this.nextToken();
            token = this.peekToken();
            int tokenType = token.getType();
            if (tokenType == 14 || tokenType == 11 || tokenType == 12 || tokenType == 5 || tokenType == 6 || tokenType == 7) {
                return new AbsoluteLocationPath(this.parseRelativeLocationPath());
            }
            return new AbsoluteLocationPath();
        }
        if (opr == 6) {
            this.nextToken();
            NodeTypeToken ntt = new NodeTypeToken(2);
            RelativeLocationPath lhs = new RelativeLocationPath(new Step(new Basis(new AxisDescendantOrSelf(), (NodeTest)new NodeType(ntt))));
            RelativeLocationPath rhs = this.parseRelativeLocationPath();
            rhs = new RelativeLocationPath(lhs, rhs);
            return new AbsoluteLocationPath(rhs);
        }
        return this.parseRelativeLocationPath();
    }

    protected RelativeLocationPath parseRelativeLocationPath() throws XPathParserException {
        RelativeLocationPath expr = new RelativeLocationPath(this.parseStep());
        Token token = this.peekToken();
        while (true) {
            int opr;
            if ((opr = this.getOperator(token)) == 5) {
                this.nextToken();
                expr = new RelativeLocationPath(expr, new RelativeLocationPath(this.parseStep()));
            } else if (opr == 6) {
                this.nextToken();
                NodeTypeToken ntt = new NodeTypeToken(2);
                RelativeLocationPath rlp = new RelativeLocationPath(new Step(new Basis(new AxisDescendantOrSelf(), (NodeTest)new NodeType(ntt))));
                expr = new RelativeLocationPath(expr, rlp);
                expr = new RelativeLocationPath(expr, new RelativeLocationPath(this.parseStep()));
            } else {
                return expr;
            }
            token = this.peekToken();
        }
    }

    protected Step parseStep() throws XPathParserException {
        Step step;
        NodeTypeToken ntt;
        Token token = this.peekToken();
        int tokenType = token.getType();
        if (tokenType == 5) {
            this.nextToken();
            ntt = new NodeTypeToken(2);
            step = new Step(new Basis(new AxisSelf(), (NodeTest)new NodeType(ntt)));
        } else if (tokenType == 6) {
            this.nextToken();
            ntt = new NodeTypeToken(2);
            step = new Step(new Basis(new AxisParent(), (NodeTest)new NodeType(ntt)));
        } else {
            step = new Step(this.parseBasis());
        }
        token = this.peekToken();
        while (token.getType() == 3) {
            this.nextToken();
            step = new Step(step, this.parsePredicate());
            token = this.peekToken();
        }
        return step;
    }

    protected Basis parseBasis() throws XPathParserException {
        Axis axis;
        Token token = this.peekToken();
        int tokenType = token.getType();
        if (tokenType == 14) {
            this.nextToken();
            if (this.peekToken().getType() != 9) {
                throw new XPathParserException("pe4", "::");
            }
            this.nextToken();
            return new Basis((AxisNameToken)token, this.parseNodeTest());
        }
        if (tokenType == 7) {
            this.nextToken();
            axis = new AxisAttribute();
        } else {
            axis = new AxisChild();
        }
        return new Basis(axis, this.parseNodeTest());
    }

    protected NodeTest parseNodeTest() throws XPathParserException {
        Token token = this.peekToken();
        int tokenType = token.getType();
        if (tokenType == 12) {
            this.nextToken();
            if (this.peekToken().getType() != 1) {
                throw new XPathParserException("pe4", '(');
            }
            this.nextToken();
            if (((NodeTypeToken)token).getNodeType() == 3) {
                LiteralToken lt = null;
                if (this.peekToken().getType() == 15) {
                    lt = (LiteralToken)this.peekToken();
                    this.nextToken();
                }
                if (this.peekToken().getType() != 2) {
                    throw new XPathParserException("pe4", ')');
                }
                this.nextToken();
                return new NodeTypePI(lt == null ? "" : lt.getValue());
            }
            if (this.peekToken().getType() != 2) {
                throw new XPathParserException("pe4", ')');
            }
            this.nextToken();
            return new NodeType((NodeTypeToken)token);
        }
        if (tokenType == 11) {
            this.nextToken();
            try {
                return new WildcardName((WildcardNameToken)token, this.namespaces);
            }
            catch (XPathException e) {
                throw new XPathParserException(e.getMessage());
            }
        }
        throw new XPathParserException("pe8");
    }

    protected Predicate parsePredicate() throws XPathParserException {
        Expression expr = this.parseExpr();
        Token token = this.peekToken();
        if (token.getType() != 4) {
            throw new XPathParserException("pe4", ']');
        }
        this.nextToken();
        return new Predicate(expr);
    }

    public void tokenize(String source) throws XPathParserException {
        Scanner scanner = new Scanner(source);
        this.tokens = scanner.scan();
        this.currentToken = 0;
    }

    public Token[] getTokens() {
        return this.tokens;
    }

    protected Token peekToken() {
        return this.currentToken < this.tokens.length ? this.tokens[this.currentToken] : this.nullToken;
    }

    protected void nextToken() {
        ++this.currentToken;
    }

    protected int getOperator(Token token) {
        return token.getType() == 10 ? ((OperatorToken)token).getOperator() : 0;
    }

    protected FunctionLibrary getLibrary() {
        return this.library;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static FunctionLibrary getDefaultFunctionLibrary() {
        Object object = libSync;
        synchronized (object) {
            if (defaultFunctionLibrary == null) {
                defaultFunctionLibrary = new FunctionLibraryImpl();
                XPathBuiltIns.addBuiltIns(defaultFunctionLibrary);
            }
        }
        return defaultFunctionLibrary;
    }

    protected VariableBindings getVariables() {
        return this.variables;
    }
}

