/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.NodeSetExpr;
import com.novell.xml.xpath.RelativeLocationPath;
import com.novell.xml.xpath.XPathEvaluationException;
import org.w3c.dom.Node;

public class PathExpr
extends NodeSetExpr
implements Expression {
    private Expression lhs;
    private RelativeLocationPath rhs;

    public PathExpr(Expression lhs, RelativeLocationPath rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionValue evaluate(Node contextNode, ExpressionContext context) throws XPathEvaluationException {
        NodeSet contextNodeList = this.lhs.evaluate(contextNode, context).getNodeSetValue();
        context.pushState();
        try {
            context.setContextNodeList(contextNodeList);
            NodeSet result = new NodeSet();
            contextNode = contextNodeList.first();
            while (contextNode != null) {
                result.union(this.rhs.evaluate(contextNode, context).getNodeSetValue());
                contextNode = contextNodeList.next();
            }
            NodeSet nodeSet = result;
            return nodeSet;
        }
        finally {
            context.popState();
        }
    }
}

