/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.NodeSetExpr;
import com.novell.xml.xpath.Step;
import com.novell.xml.xpath.XPathEvaluationException;
import org.w3c.dom.Node;

public class RelativeLocationPath
extends NodeSetExpr
implements Expression {
    private Step[] steps;

    public RelativeLocationPath(Step step) {
        this.steps = new Step[1];
        this.steps[0] = step;
    }

    public RelativeLocationPath(Step[] steps) {
        this.steps = steps;
    }

    public RelativeLocationPath(RelativeLocationPath lhs, RelativeLocationPath rhs) {
        int i;
        this.steps = new Step[lhs.steps.length + rhs.steps.length];
        for (i = 0; i < lhs.steps.length; ++i) {
            this.steps[i] = lhs.steps[i];
        }
        for (int j = 0; j < rhs.steps.length; ++j) {
            this.steps[i] = rhs.steps[j];
            ++i;
        }
    }

    public String toString() {
        String result = this.steps[0].toString();
        for (int i = 1; i < this.steps.length; ++i) {
            result = result + "/" + this.steps[i].toString();
        }
        return result;
    }

    public ExpressionValue evaluate(Node contextNode, ExpressionContext context) throws XPathEvaluationException {
        NodeSet nodeSet = new NodeSet();
        this.evalStep(nodeSet, 0, contextNode, context);
        return nodeSet;
    }

    protected void evalStep(NodeSet result, int index, Node contextNode, ExpressionContext context) throws XPathEvaluationException {
        if (index >= this.steps.length) {
            result.add(contextNode);
            return;
        }
        this.steps[index].setup(contextNode, context);
        Node node = this.steps[index].first();
        while (node != null) {
            this.evalStep(result, index + 1, node, context);
            node = this.steps[index].next();
        }
        this.steps[index].done();
    }
}

