/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.AxisNameToken;
import com.novell.xml.xpath.FunctionNameToken;
import com.novell.xml.xpath.LiteralToken;
import com.novell.xml.xpath.NodeTypeToken;
import com.novell.xml.xpath.NumberToken;
import com.novell.xml.xpath.OperatorToken;
import com.novell.xml.xpath.QName;
import com.novell.xml.xpath.Token;
import com.novell.xml.xpath.VariableRefToken;
import com.novell.xml.xpath.WildcardNameToken;
import com.novell.xml.xpath.XPathParserException;
import java.util.Vector;

public class Scanner {
    private String input;
    private int index;
    private Vector tokens;
    private final int[] posStack = new int[8];
    private int stackTop;
    protected static final char EAT_CHAR = '\ufffd';

    public Scanner(String string) {
        this.input = string;
        this.index = 0;
        this.tokens = new Vector(8, 8);
    }

    public Token[] scan() throws XPathParserException {
        char scanChar;
        this.reset();
        while ((scanChar = this.getNextXMLChar()) != '\u0000') {
            if (XMLUtil.isNCName(scanChar)) {
                this.handleQName(this.scanQName(scanChar));
                continue;
            }
            if (scanChar == '\"' || scanChar == '\'') {
                this.handleLiteral(scanChar);
                continue;
            }
            if (this.isDigit(scanChar)) {
                this.handleNumber(scanChar);
                continue;
            }
            this.handleChar(scanChar);
        }
        this.done();
        return this.returnTokens();
    }

    public static double scanNumber(String string) {
        boolean gotPoint = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                if (gotPoint) {
                    return Double.NaN;
                }
                gotPoint = true;
                continue;
            }
            if (c >= '0' && c <= '9') continue;
            return Double.NaN;
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    protected char prescanChar(char scanChar) {
        return scanChar;
    }

    protected void done() {
    }

    protected void handleQName(QName qName) throws XPathParserException {
        char nextChar;
        if (qName.getPrefix().length() == 0) {
            this.pushPos();
            nextChar = this.getNextXMLChar();
            if (nextChar == ':') {
                nextChar = this.getNextChar();
                if (nextChar == '*') {
                    this.tossPos();
                    this.appendToken(new WildcardNameToken(qName.getName(), "*"));
                    return;
                }
                if (nextChar == ':') {
                    this.popPos();
                    int axisId = AxisNameToken.getAxisIdentifier(qName.getName());
                    if (axisId == 0) {
                        throw new XPathParserException("pe1");
                    }
                    this.appendToken(new AxisNameToken(axisId));
                    return;
                }
            }
            this.popPos();
        }
        this.pushPos();
        nextChar = this.getNextXMLChar();
        this.popPos();
        if (qName.getPrefix().length() == 0) {
            int type = OperatorToken.getOpType(qName.getName());
            if (type != 0 && this.checkOpNameMulOpState()) {
                this.appendToken(new OperatorToken(type));
                return;
            }
            type = NodeTypeToken.getTypeFromName(qName.getName());
            if (type != 0 && nextChar == '(') {
                this.appendToken(new NodeTypeToken(type));
                return;
            }
        }
        if (nextChar == '(') {
            this.appendToken(new FunctionNameToken(qName.getPrefix(), qName.getName()));
        } else {
            this.appendToken(new WildcardNameToken(qName.getPrefix(), qName.getName()));
        }
    }

    protected void handleChar(char scanChar) throws XPathParserException {
        switch (scanChar) {
            case '(': {
                this.appendToken(new Token(1));
                break;
            }
            case ')': {
                this.appendToken(new Token(2));
                break;
            }
            case '[': {
                this.appendToken(new Token(3));
                break;
            }
            case ']': {
                this.appendToken(new Token(4));
                break;
            }
            case '.': {
                this.pushPos();
                char nextChar = this.getNextChar();
                if (nextChar == '.') {
                    this.tossPos();
                    this.appendToken(new Token(6));
                    break;
                }
                if (this.isDigit(nextChar)) {
                    this.popPos();
                    this.handleNumber('.');
                    break;
                }
                this.popPos();
                this.appendToken(new Token(5));
                break;
            }
            case '@': {
                this.appendToken(new Token(7));
                break;
            }
            case ',': {
                this.appendToken(new Token(8));
                break;
            }
            case ':': {
                this.pushPos();
                if (this.getNextChar() == ':') {
                    this.tossPos();
                    this.appendToken(new Token(9));
                    break;
                }
                throw new XPathParserException("pe3", scanChar);
            }
            case '*': {
                if (this.checkOpNameMulOpState()) {
                    this.appendToken(new OperatorToken(2));
                    break;
                }
                this.appendToken(new WildcardNameToken("", "*"));
                break;
            }
            case '/': {
                this.pushPos();
                if (this.getNextChar() == '/') {
                    this.tossPos();
                    this.appendToken(new OperatorToken(6));
                    break;
                }
                this.popPos();
                this.appendToken(new OperatorToken(5));
                break;
            }
            case '|': {
                this.appendToken(new OperatorToken(16));
                break;
            }
            case '+': {
                this.appendToken(new OperatorToken(3));
                break;
            }
            case '-': {
                this.appendToken(new OperatorToken(4));
                break;
            }
            case '=': {
                this.appendToken(new OperatorToken(9));
                break;
            }
            case '!': {
                if (this.getNextChar() != '=') {
                    throw new XPathParserException("pe4", "=");
                }
                this.appendToken(new OperatorToken(1));
                break;
            }
            case '<': {
                this.pushPos();
                if (this.getNextChar() == '=') {
                    this.tossPos();
                    this.appendToken(new OperatorToken(8));
                    break;
                }
                this.popPos();
                this.appendToken(new OperatorToken(7));
                break;
            }
            case '>': {
                this.pushPos();
                if (this.getNextChar() == '=') {
                    this.tossPos();
                    this.appendToken(new OperatorToken(11));
                    break;
                }
                this.popPos();
                this.appendToken(new OperatorToken(10));
                break;
            }
            case '$': {
                QName varRef;
                char nextChar = this.getNextChar();
                if (nextChar == '\u0000' || (varRef = this.scanQName(nextChar)).isEmpty()) {
                    throw new XPathParserException("pe2");
                }
                this.appendToken(new VariableRefToken(varRef.getPrefix(), varRef.getName()));
                break;
            }
            case '\ufffd': {
                break;
            }
            default: {
                throw new XPathParserException("pe3", scanChar);
            }
        }
    }

    protected void handleLiteral(char startQuote) {
        char nextChar;
        StringBuffer buffer = new StringBuffer(128);
        while ((nextChar = this.getNextChar()) != '\u0000' && nextChar != startQuote) {
            buffer.append(nextChar);
        }
        this.appendToken(new LiteralToken(buffer.toString()));
    }

    protected void handleNumber(char startChar) {
        StringBuffer buffer = new StringBuffer(16);
        buffer.append(startChar);
        boolean gotDot = startChar == '.';
        while (true) {
            this.pushPos();
            char nextChar = this.getNextChar();
            if (nextChar == '.') {
                if (gotDot) {
                    this.popPos();
                    break;
                }
                gotDot = true;
            } else if (!this.isDigit(nextChar)) {
                this.popPos();
                break;
            }
            this.tossPos();
            buffer.append(nextChar);
        }
        this.appendToken(new NumberToken(Double.valueOf(buffer.toString())));
    }

    protected boolean checkOpNameMulOpState() {
        if (this.tokens.isEmpty()) {
            return false;
        }
        Token token = (Token)this.tokens.lastElement();
        int tokenType = token.getType();
        return tokenType != 7 && tokenType != 1 && tokenType != 3 && tokenType != 10 && tokenType != 9;
    }

    protected QName scanQName(char firstChar) {
        String prefix = this.scanNCName(firstChar);
        this.pushPos();
        if (this.getNextChar() == ':' && XMLUtil.isNCNameChar(firstChar = this.getNextChar())) {
            this.tossPos();
            return new QName(prefix, this.scanNCName(firstChar));
        }
        this.popPos();
        return new QName("", prefix);
    }

    protected String scanNCName(char firstChar) {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(firstChar);
        while (true) {
            this.pushPos();
            char scanChar = this.getNextChar();
            if (!XMLUtil.isNCNameChar(scanChar)) break;
            buffer.append(scanChar);
            this.tossPos();
        }
        this.popPos();
        return buffer.toString();
    }

    protected char getNextXMLChar() {
        while (this.index < this.input.length()) {
            char scanChar;
            if ((scanChar = this.prescanChar(this.input.charAt(this.index++))) == '\u0000' || XMLUtil.isXMLWhitespace(scanChar)) continue;
            return scanChar;
        }
        return '\u0000';
    }

    protected char getNextChar() {
        if (this.index < this.input.length()) {
            return this.input.charAt(this.index++);
        }
        return '\u0000';
    }

    protected boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    protected void reset() {
        this.tokens.removeAllElements();
        this.stackTop = 0;
        this.index = 0;
    }

    protected void pushPos() {
        this.posStack[this.stackTop++] = this.index;
    }

    protected void tossPos() {
        --this.stackTop;
    }

    protected void popPos() {
        this.index = this.posStack[--this.stackTop];
    }

    protected final void appendToken(Token token) {
        this.tokens.addElement(token);
    }

    protected final Token lastToken() {
        if (this.tokens.isEmpty()) {
            return null;
        }
        return (Token)this.tokens.lastElement();
    }

    protected Token[] returnTokens() {
        Token[] result = new Token[this.tokens.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Token)this.tokens.elementAt(i);
        }
        return result;
    }
}

