/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Basis;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.Predicate;
import com.novell.xml.xpath.XPathEvaluationException;
import org.w3c.dom.Node;

public class Step {
    private Basis basis;
    private Predicate[] predicates = null;
    private ExpressionContext context;
    private ContextNodeList list;

    public Step(Basis basis) {
        this.basis = basis;
    }

    public Step(Basis basis, Predicate predicate) {
        this.basis = basis;
        this.predicates = new Predicate[1];
        this.predicates[0] = predicate;
    }

    public Step(Basis basis, Predicate[] predicates) {
        this.basis = basis;
        this.predicates = predicates;
    }

    public Step(Step step, Predicate predicate) {
        this.basis = step.basis;
        if (step.predicates != null) {
            this.predicates = new Predicate[step.predicates.length + 1];
            for (int i = 0; i < step.predicates.length; ++i) {
                this.predicates[i] = step.predicates[i];
            }
            this.predicates[i] = predicate;
        } else {
            this.predicates = new Predicate[1];
            this.predicates[0] = predicate;
        }
    }

    public void setup(Node contextNode, ExpressionContext context) {
        this.context = context;
        this.basis.setup(contextNode, context);
        if (this.predicates != null && this.predicates.length > 0) {
            context.pushState();
            context.setContextNodeList(this.basis);
            this.predicates[0].setup(context);
            for (int i = 1; i < this.predicates.length; ++i) {
                ExpressionContext predicateContext = new ExpressionContext(context);
                predicateContext.setContextNodeList(this.predicates[i - 1]);
                this.predicates[i].setup(predicateContext);
            }
            this.list = this.predicates[this.predicates.length - 1];
        } else {
            this.list = this.basis;
        }
    }

    public void done() {
        if (this.context != null && this.predicates != null && this.predicates.length > 0) {
            this.context.popState();
        }
        if (this.predicates != null && this.predicates.length > 0) {
            for (int i = 0; i < this.predicates.length; ++i) {
                this.predicates[i].done();
            }
        }
        this.list = null;
        this.context = null;
        this.basis.done();
    }

    public Node first() throws XPathEvaluationException {
        if (this.list == null) {
            return null;
        }
        return this.list.first();
    }

    public Node next() throws XPathEvaluationException {
        if (this.list == null) {
            return null;
        }
        return this.list.next();
    }

    public String toString() {
        String result = this.basis.toString();
        if (this.predicates != null) {
            for (int i = 0; i < this.predicates.length; ++i) {
                result = result + this.predicates[i].toString();
            }
        }
        return result;
    }
}

