/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.XPathConversionException;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xml.xpath.XPathUtil;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class StringValue
implements ExpressionValue,
Expression,
Comparable {
    private String value;
    private static final Class argType = XPathUtil.doGetClass("com.novell.xml.xpath.StringValue");

    public StringValue(String v) {
        this.value = v;
    }

    public StringValue() {
        this.value = "";
    }

    public static Class getArgType() {
        return argType;
    }

    public String toString() {
        return this.getStringValue();
    }

    public ExpressionValue evaluate(Node contextNode, ExpressionContext context) {
        return this;
    }

    public boolean isConstant() {
        return true;
    }

    public Class getResultType() {
        return StringValue.getArgType();
    }

    public void registerForReset(XPathResetRegistrar registrar) {
    }

    public void dump(PrintWriter writer, int indent) {
        XPathUtil.dump(this, writer, indent);
    }

    public int getValueType() {
        return 2;
    }

    public void castFrom(Object type) throws XPathConversionException {
        this.value = type instanceof ExpressionValue ? ((ExpressionValue)type).getStringValue() : type.toString();
    }

    public boolean getBooleanValue() throws XPathConversionException {
        return this.value.length() > 0;
    }

    public double getNumberValue() throws XPathConversionException {
        return NumberValue.convertToNumber(this.value);
    }

    public String getStringValue() {
        return this.value;
    }

    public NodeSet getNodeSetValue() throws XPathConversionException {
        throw new XPathConversionException("vce1");
    }

    public Object getNativeValue() {
        return this.value;
    }

    public void dump(PrintWriter writer) {
        writer.println("\"" + this.value + "\"");
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        Object otherValue = null;
        if (other instanceof StringValue) {
            return this.value.equals(((StringValue)other).value);
        }
        if (other instanceof String) {
            return this.value.equals((String)other);
        }
        return false;
    }

    public int compareTo(Object other) {
        if (other instanceof StringValue) {
            return this.value.compareTo(((StringValue)other).value);
        }
        return this.value.compareTo((String)other);
    }
}

