/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xml.xpath.XPathUtil;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class UnaryExpr
implements Expression {
    private Expression operand;

    public UnaryExpr(Expression operand) {
        this.operand = operand;
    }

    public String toString() {
        return "-" + this.operand.toString();
    }

    public ExpressionValue evaluate(Node contextNode, ExpressionContext context) throws XPathEvaluationException {
        return new NumberValue(-this.operand.evaluate(contextNode, context).getNumberValue());
    }

    public boolean isConstant() {
        return this.operand.isConstant();
    }

    public void dump(PrintWriter writer, int indent) {
        XPathUtil.dump(this, writer, indent);
    }

    public Class getResultType() {
        return NumberValue.getArgType();
    }

    public void registerForReset(XPathResetRegistrar registrar) {
    }
}

