/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.xpath.NamespaceContext;
import com.novell.xml.xpath.NodeTest;
import com.novell.xml.xpath.WildcardNameToken;
import com.novell.xml.xpath.XPathException;
import com.novell.xml.xpath.XPathParserException;
import org.w3c.dom.Node;

public class WildcardName
implements NodeTest {
    ExpandedQName name;
    private final boolean fullWild;
    private final boolean localWild;
    private int principalNodeType = 1;

    public WildcardName(WildcardNameToken token, NamespaceContext nsContext) throws XPathException {
        String prefix = token.getPrefix();
        String localName = token.getNCName();
        this.localWild = localName.equals("*");
        this.fullWild = prefix.length() == 0 && this.localWild;
        this.initName(prefix, localName, nsContext);
    }

    public WildcardName(String name, NamespaceContext nsContext) throws XPathException {
        String localName;
        String prefix;
        int index = name.indexOf(58);
        if (index > 0) {
            prefix = name.substring(0, index);
            localName = name.substring(index + 1, name.length());
        } else {
            prefix = "";
            localName = name;
        }
        this.localWild = localName.equals("*");
        this.fullWild = prefix.length() == 0 && this.localWild;
        this.initName(prefix, localName, nsContext);
    }

    public void setPrincipalNodeType(int principalNodeType) {
        this.principalNodeType = principalNodeType;
    }

    public boolean evaluate(Node node) {
        if (node.getNodeType() != this.principalNodeType) {
            return false;
        }
        if (this.fullWild) {
            return true;
        }
        ExpandedQName nodeName = DOMUtil.getExpandedName(node);
        if (this.localWild) {
            return this.name.namespaceNameEquals(nodeName);
        }
        return this.name.equals(nodeName);
    }

    public ExpandedQName getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.name.getPrefix();
    }

    public String getLocalPart() {
        return this.name.getLocalPart();
    }

    public NamespaceName getNamespaceName() {
        return this.name.getNamespaceName();
    }

    public boolean isFullWild() {
        return this.fullWild;
    }

    public boolean isLocalWild() {
        return this.localWild;
    }

    public String toString() {
        return this.name.getQName();
    }

    protected void initName(String prefix, String localPart, NamespaceContext nsContext) throws XPathException {
        NamespaceName namespaceName;
        if (prefix.length() > 0) {
            namespaceName = nsContext.getNamespaceName(prefix);
            if (namespaceName.isEmpty()) {
                throw new XPathParserException("pe13", prefix);
            }
        } else {
            namespaceName = NamespaceName.NULL_NAMESPACE;
        }
        this.name = new ExpandedQName(namespaceName, localPart, prefix);
    }
}

