/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.dom.Namespace;
import com.novell.xml.dom.NodeDecorator;
import com.novell.xml.util.NamespaceName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathNamespaceNode
extends NodeDecorator
implements Comparable,
Namespace {
    private Node ownerElement;
    private String prefix;
    private NamespaceName namespaceName;

    public XPathNamespaceNode(String prefix, String uri, Node ownerElement) {
        super(XPathNamespaceNode.createBase(prefix.length() > 0 ? "xmlns:" + prefix : "xmlns", ownerElement));
        this.ownerElement = ownerElement;
        this.prefix = prefix;
        this.namespaceName = new NamespaceName(uri);
    }

    private static Node createBase(String prefix, Node ownerElement) {
        Document document = ownerElement.getOwnerDocument();
        document = document == null ? (Document)ownerElement : document;
        Attr attr = document.createAttribute(prefix);
        return attr;
    }

    public final short getNodeType() {
        return -1;
    }

    public final Node getParentNode() {
        return this.ownerElement;
    }

    public final String getNodeName() {
        return this.prefix;
    }

    public final String getNodeValue() {
        return this.namespaceName.getString();
    }

    public NamespaceName getNamespaceName() {
        return this.namespaceName;
    }

    public int compareTo(Object obj) {
        int result;
        if (obj instanceof Node) {
            result = ((Node)obj).getNodeType() == 2 ? 1 : -1;
        } else if (obj instanceof XPathNamespaceNode) {
            XPathNamespaceNode ns = (XPathNamespaceNode)obj;
            result = this.getNodeName().compareTo(ns.getNodeName());
            if (result == 0) {
                result = this.getNodeValue().compareTo(ns.getNodeValue());
            }
        } else {
            result = -1;
        }
        return result;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

