/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.dom.DOMUtil;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public final class XPathUtil {
    public static short getNodeType(Node node) {
        short type = node.getNodeType();
        if (type == 4) {
            type = 3;
        }
        return (short)type;
    }

    public static String getNodeValue(Node node) {
        String result;
        if (node == null) {
            return "";
        }
        switch (XPathUtil.getNodeType(node)) {
            case 1: {
                result = XPathUtil.getStringValue(node);
                break;
            }
            case 2: {
                result = node.getNodeValue();
                break;
            }
            case 9: {
                result = XPathUtil.getStringValue(node);
                break;
            }
            case 11: {
                result = XPathUtil.getNodeValue(node.getFirstChild());
                break;
            }
            case 3: {
                Node temp;
                for (temp = node.getPreviousSibling(); temp != null && XPathUtil.getNodeType(temp) == 3; temp = temp.getPreviousSibling()) {
                    node = temp;
                }
                temp = node.getNextSibling();
                if (temp == null || XPathUtil.getNodeType(temp) != 3) {
                    result = node.getNodeValue();
                    break;
                }
                StringBuffer sb = new StringBuffer();
                do {
                    sb.append(node.getNodeValue());
                } while ((node = node.getNextSibling()) != null && XPathUtil.getNodeType(node) == 3);
                result = sb.toString();
                break;
            }
            default: {
                result = node.getNodeValue();
            }
        }
        return result != null ? result : "";
    }

    private static String getStringValue(Node node) {
        Node childNode = node.getFirstChild();
        if (childNode == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(256);
        XPathUtil.getStringValue(node, buffer);
        return buffer.toString();
    }

    private static void getStringValue(Node node, StringBuffer buffer) {
        block4: for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            switch (XPathUtil.getNodeType(childNode)) {
                case 1: {
                    XPathUtil.getStringValue(childNode, buffer);
                    continue block4;
                }
                case 3: {
                    buffer.append(childNode.getNodeValue());
                }
            }
        }
    }

    public static Node getNextSibling(Node node) {
        short type = XPathUtil.getNodeType(node);
        if (type == 3) {
            for (node = node.getNextSibling(); node != null && XPathUtil.getNodeType(node) == 3; node = node.getNextSibling()) {
            }
        }
        return node;
    }

    public static Node getPreviousSibling(Node node) {
        block3: {
            block2: {
                short type = XPathUtil.getNodeType(node);
                if (type != 3) break block2;
                for (node = node.getPreviousSibling(); node != null && XPathUtil.getNodeType(node) == 3; node = node.getPreviousSibling()) {
                }
                break block3;
            }
            if (node == null || XPathUtil.getNodeType(node) != 3) break block3;
            while (node.getPreviousSibling() != null && XPathUtil.getNodeType(node.getPreviousSibling()) == 3) {
                node = node.getPreviousSibling();
            }
        }
        return node;
    }

    public static Class doGetClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String describeNode(Node node) {
        if (node.getNodeType() == -1) {
            return "<xmlns" + (node.getNodeName().length() > 0 ? ":" : "") + node.getNodeName() + "=\"" + node.getNodeValue() + "\">";
        }
        return DOMUtil.describeNode(node);
    }

    public static void dump(Object obj, PrintWriter writer, int indent) {
        for (int i = 0; i < indent; ++i) {
            writer.print("\t");
        }
        writer.println(obj.toString());
    }

    private XPathUtil() {
    }
}

