/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath.functions;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathUtil;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class xpathId
extends Function {
    public xpathId() {
        super(xpathId.createSignature());
    }

    public ExpressionValue invoke(Object[] args) throws XPathEvaluationException {
        try {
            Node contextNode = (Node)args[0];
            ExpressionValue arg = (ExpressionValue)args[2];
            Vector<String> sList = new Vector<String>(8, 8);
            if (arg.getValueType() == 3) {
                NodeSet set = (NodeSet)arg;
                Node node = set.first();
                while (node != null) {
                    String s = XPathUtil.getNodeValue(node);
                    if (s != null && s.length() > 0) {
                        sList.addElement(s);
                    }
                    node = set.next();
                }
            } else {
                sList.addElement(arg.getStringValue());
            }
            NodeSet result = new NodeSet();
            if (sList.size() != 0) {
                Vector<String> list = new Vector<String>(8, 8);
                StringBuffer sb = new StringBuffer(16);
                int len = sList.size();
                for (int i = 0; i < len; ++i) {
                    sb.setLength(0);
                    String s = (String)sList.elementAt(i);
                    for (int j = 0; j < s.length(); ++j) {
                        char c = s.charAt(j);
                        if (XMLUtil.isXMLWhitespace(c)) {
                            if (sb.length() == 0) continue;
                            list.addElement(sb.toString());
                            sb.setLength(0);
                            continue;
                        }
                        sb.append(c);
                    }
                    if (sb.length() == 0) continue;
                    list.addElement(sb.toString());
                }
                Document document = contextNode.getOwnerDocument();
                if (document == null) {
                    document = (Document)contextNode;
                }
                for (int i = 0; i < list.size(); ++i) {
                    Element e = DOMUtil.getElementByID(document, (String)list.elementAt(i));
                    if (e == null) continue;
                    result.add(e);
                }
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new XPathEvaluationException("pe9");
        }
    }

    public String toString() {
        return "id";
    }

    private static FunctionSignature createSignature() {
        try {
            Class[] reqArgs = new Class[]{FunctionSignature.getContextArgTypes()[0], FunctionSignature.getContextArgTypes()[1], Class.forName("com.novell.xml.xpath.ExpressionValue")};
            return new FunctionSignature(new ExpandedQName("", "id"), NodeSet.getArgType(), reqArgs);
        }
        catch (ClassNotFoundException e) {
            throw new Error(e.getLocalizedMessage());
        }
    }
}

