/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath.functions;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.BooleanValue;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathEvaluationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class xpathLang
extends Function {
    public xpathLang() {
        super(xpathLang.createSignature());
    }

    public ExpressionValue invoke(Object[] args) throws XPathEvaluationException {
        try {
            Node contextNode = (Node)args[0];
            String langString = ((ExpressionValue)args[2]).getStringValue();
            String xmlLang = this.findLang(contextNode);
            if (langString.equalsIgnoreCase(xmlLang)) {
                return new BooleanValue(true);
            }
            int index = xmlLang.lastIndexOf(45);
            if (index != -1) {
                return new BooleanValue(langString.equalsIgnoreCase(xmlLang.substring(0, index)));
            }
            return new BooleanValue(false);
        }
        catch (ClassCastException e) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new XPathEvaluationException("pe9");
        }
    }

    private String findLang(Node node) {
        while (node != null) {
            Attr attr;
            if (node.getNodeType() == 1 && (attr = ((Element)node).getAttributeNode("xml:lang")) != null) {
                return attr.getValue();
            }
            node = node.getParentNode();
        }
        return "";
    }

    private static FunctionSignature createSignature() {
        Class[] reqArgs = new Class[]{FunctionSignature.getContextArgTypes()[0], FunctionSignature.getContextArgTypes()[1], StringValue.getArgType()};
        return new FunctionSignature(new ExpandedQName("", "lang"), BooleanValue.getArgType(), reqArgs);
    }
}

