/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath.functions;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathEvaluationException;
import org.w3c.dom.Node;

public class xpathLocalName
extends Function {
    public xpathLocalName() {
        super(xpathLocalName.createSignature());
    }

    public ExpressionValue invoke(Object[] args) throws XPathEvaluationException {
        try {
            Node node = args.length > 2 ? ((NodeSet)args[2]).first() : (Node)args[0];
            if (node != null) {
                switch (node.getNodeType()) {
                    case -1: 
                    case 1: 
                    case 2: 
                    case 7: {
                        return new StringValue(DOMUtil.getLocalName(node));
                    }
                }
            }
            return new StringValue("");
        }
        catch (ClassCastException e) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new XPathEvaluationException("pe9");
        }
    }

    public String toString() {
        return "local-name";
    }

    private static FunctionSignature createSignature() {
        Class[] optArgs = new Class[]{NodeSet.getArgType()};
        return new FunctionSignature(new ExpandedQName("", "local-name"), StringValue.getArgType(), FunctionSignature.getContextArgTypes(), optArgs);
    }
}

