/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath.functions;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathUtil;
import org.w3c.dom.Node;

public class xpathStringLength
extends Function {
    public xpathStringLength() {
        super(xpathStringLength.createSignature());
    }

    public ExpressionValue invoke(Object[] args) throws XPathEvaluationException {
        try {
            String string = args.length > 2 ? ((ExpressionValue)args[2]).getStringValue() : XPathUtil.getNodeValue((Node)args[0]);
            int count = 0;
            boolean high = false;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c < '\ud800' || c > '\udfff') {
                    high = false;
                } else if (c >= '\udc00') {
                    if (high) {
                        high = false;
                        continue;
                    }
                    high = false;
                } else {
                    high = true;
                }
                ++count;
            }
            return new NumberValue(count);
        }
        catch (ClassCastException e) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new XPathEvaluationException("pe9");
        }
    }

    public String toString() {
        return "string-length";
    }

    private static FunctionSignature createSignature() {
        Class[] optArgs = new Class[]{StringValue.getArgType()};
        return new FunctionSignature(new ExpandedQName("", "string-length"), NumberValue.getArgType(), FunctionSignature.getContextArgTypes(), optArgs);
    }
}

