/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath.functions;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathEvaluationException;

public class xpathSubstring
extends Function {
    public xpathSubstring() {
        super(xpathSubstring.createSignature());
    }

    public ExpressionValue invoke(Object[] args) throws XPathEvaluationException {
        try {
            String string = ((ExpressionValue)args[0]).getStringValue();
            int start = (int)Math.round(((ExpressionValue)args[1]).getNumberValue());
            int len = string.length();
            int end = args.length > 2 ? (int)Math.round(((ExpressionValue)args[2]).getNumberValue()) + start : len + 1;
            if (end > start && start <= len) {
                int j;
                start = start < 1 ? 1 : start;
                int i = this.findIndex(--start, string);
                int n = i = i < 0 ? 0 : i;
                if ((end -= 2) >= len - 1) {
                    j = len - 1;
                } else if (end < 0) {
                    j = -1;
                } else {
                    j = this.findIndex(end, string);
                    char c = string.charAt(j);
                    if (c >= '\ud800' && c <= '\udbff' && j + 1 < string.length() && (c = string.charAt(j + 1)) >= '\udc00' && c <= '\udfff') {
                        ++j;
                    }
                }
                return new StringValue(string.substring(i, j + 1));
            }
            return new StringValue();
        }
        catch (ClassCastException e) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new XPathEvaluationException("pe9");
        }
    }

    private int findIndex(int index, String string) {
        int i;
        boolean high = false;
        int max = string.length();
        for (i = 0; index > 0 && i < max; ++i) {
            char c = string.charAt(i);
            if (c < '\ud800' || c > '\udfff') {
                high = false;
            } else if (c >= '\udc00') {
                high = false;
            } else {
                high = true;
                continue;
            }
            --index;
        }
        return i < max ? i : -1;
    }

    public String toString() {
        return "substring";
    }

    private static FunctionSignature createSignature() {
        Class[] reqArgs = new Class[]{StringValue.getArgType(), NumberValue.getArgType()};
        Class[] optArgs = new Class[]{NumberValue.getArgType()};
        return new FunctionSignature(new ExpandedQName("", "substring"), StringValue.getArgType(), reqArgs, optArgs);
    }
}

