/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath.functions;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathUtil;
import org.w3c.dom.Node;

public class xpathSum
extends Function {
    public xpathSum() {
        super(xpathSum.createSignature());
    }

    public ExpressionValue invoke(Object[] args) throws XPathEvaluationException {
        try {
            NodeSet set = (NodeSet)args[0];
            Node node = set.first();
            double sum = 0.0;
            while (node != null) {
                double d;
                String s = XPathUtil.getNodeValue(node);
                if (s != null && !Double.isNaN(d = NumberValue.convertToNumber(s))) {
                    sum += Double.valueOf(s).doubleValue();
                }
                node = set.next();
            }
            return new NumberValue(sum);
        }
        catch (ClassCastException e) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new XPathEvaluationException("pe9");
        }
    }

    public String toString() {
        return "sum";
    }

    private static FunctionSignature createSignature() {
        Class[] reqArg = new Class[]{NodeSet.getArgType()};
        return new FunctionSignature(new ExpandedQName("", "sum"), NumberValue.getArgType(), reqArg);
    }
}

