/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl;

import com.novell.xsl.ErrorHandler;
import com.novell.xsl.XSLException;
import java.io.PrintWriter;

public class DefaultErrorHandler
implements ErrorHandler {
    private PrintWriter output;
    private boolean logErrors = true;
    private boolean logWarnings = true;
    private int errorCount = 0;
    private int warningCount = 0;

    public DefaultErrorHandler() {
        this.createOutput();
    }

    public DefaultErrorHandler(PrintWriter output) {
        this.output = output;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void resetCounts() {
        this.errorCount = 0;
        this.warningCount = 0;
    }

    public void setLogErrors(boolean logErrors) {
        this.logErrors = logErrors;
    }

    public void setLogWarnings(boolean logWarnings) {
        this.logWarnings = logWarnings;
    }

    public void error(String message) throws XSLException {
        ++this.errorCount;
        if (this.logErrors) {
            String msg = XSLException.constructMessage("e1", new String[]{message});
            this.output.println(msg);
            this.output.flush();
        }
    }

    public void warning(String message) {
        ++this.warningCount;
        if (this.logWarnings) {
            String msg = XSLException.constructMessage("e2", new String[]{message});
            this.output.println(msg);
            this.output.flush();
        }
    }

    private void createOutput() {
        this.output = new PrintWriter(System.err);
    }
}

